/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.CheckpointConfig;

@SdkInternalApi
public class CheckpointConfigMarshaller {
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Uri").build();
    private static final MarshallingInfo<String> LOCALPATH_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LocalPath").build();
    private static final CheckpointConfigMarshaller instance = new CheckpointConfigMarshaller();

    public static CheckpointConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(CheckpointConfig checkpointConfig, ProtocolMarshaller protocolMarshaller) {
        if (checkpointConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(checkpointConfig.getS3Uri(), S3URI_BINDING);
            protocolMarshaller.marshall(checkpointConfig.getLocalPath(), LOCALPATH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

