/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemaker.model.ChannelSpecification;
import java.util.List;

@SdkInternalApi
public class ChannelSpecificationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<Boolean> ISREQUIRED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsRequired").build();
    private static final MarshallingInfo<List> SUPPORTEDCONTENTTYPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedContentTypes").build();
    private static final MarshallingInfo<List> SUPPORTEDCOMPRESSIONTYPES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedCompressionTypes").build();
    private static final MarshallingInfo<List> SUPPORTEDINPUTMODES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedInputModes").build();
    private static final ChannelSpecificationMarshaller instance = new ChannelSpecificationMarshaller();

    public static ChannelSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ChannelSpecification channelSpecification, ProtocolMarshaller protocolMarshaller) {
        if (channelSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(channelSpecification.getName(), NAME_BINDING);
            protocolMarshaller.marshall(channelSpecification.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(channelSpecification.getIsRequired(), ISREQUIRED_BINDING);
            protocolMarshaller.marshall(channelSpecification.getSupportedContentTypes(), SUPPORTEDCONTENTTYPES_BINDING);
            protocolMarshaller.marshall(channelSpecification.getSupportedCompressionTypes(), SUPPORTEDCOMPRESSIONTYPES_BINDING);
            protocolMarshaller.marshall(channelSpecification.getSupportedInputModes(), SUPPORTEDINPUTMODES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

