/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.AutoMLDataSource;

@SdkInternalApi
public class AutoMLDataSourceMarshaller {
    private static final MarshallingInfo<StructuredPojo> S3DATASOURCE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DataSource").build();
    private static final AutoMLDataSourceMarshaller instance = new AutoMLDataSourceMarshaller();

    public static AutoMLDataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(AutoMLDataSource autoMLDataSource, ProtocolMarshaller protocolMarshaller) {
        if (autoMLDataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(autoMLDataSource.getS3DataSource(), S3DATASOURCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

