/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.AsyncInferenceConfig;

@SdkInternalApi
public class AsyncInferenceConfigMarshaller {
    private static final MarshallingInfo<StructuredPojo> CLIENTCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientConfig").build();
    private static final MarshallingInfo<StructuredPojo> OUTPUTCONFIG_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputConfig").build();
    private static final AsyncInferenceConfigMarshaller instance = new AsyncInferenceConfigMarshaller();

    public static AsyncInferenceConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(AsyncInferenceConfig asyncInferenceConfig, ProtocolMarshaller protocolMarshaller) {
        if (asyncInferenceConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(asyncInferenceConfig.getClientConfig(), CLIENTCONFIG_BINDING);
            protocolMarshaller.marshall(asyncInferenceConfig.getOutputConfig(), OUTPUTCONFIG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

