/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.AppDetails;
import java.util.Date;

@SdkInternalApi
public class AppDetailsMarshaller {
    private static final MarshallingInfo<String> DOMAINID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DomainId").build();
    private static final MarshallingInfo<String> USERPROFILENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserProfileName").build();
    private static final MarshallingInfo<String> SPACENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SpaceName").build();
    private static final MarshallingInfo<String> APPTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppType").build();
    private static final MarshallingInfo<String> APPNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppName").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> RESOURCESPEC_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceSpec").build();
    private static final AppDetailsMarshaller instance = new AppDetailsMarshaller();

    public static AppDetailsMarshaller getInstance() {
        return instance;
    }

    public void marshall(AppDetails appDetails, ProtocolMarshaller protocolMarshaller) {
        if (appDetails == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(appDetails.getDomainId(), DOMAINID_BINDING);
            protocolMarshaller.marshall(appDetails.getUserProfileName(), USERPROFILENAME_BINDING);
            protocolMarshaller.marshall(appDetails.getSpaceName(), SPACENAME_BINDING);
            protocolMarshaller.marshall(appDetails.getAppType(), APPTYPE_BINDING);
            protocolMarshaller.marshall(appDetails.getAppName(), APPNAME_BINDING);
            protocolMarshaller.marshall(appDetails.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(appDetails.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(appDetails.getResourceSpec(), RESOURCESPEC_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

