/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.AdditionalInferenceSpecificationDefinition;
import com.amazonaws.services.sagemaker.model.InferenceSpecification;
import com.amazonaws.services.sagemaker.model.ModelApprovalStatus;
import com.amazonaws.services.sagemaker.model.ModelPackageModelCard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateModelPackageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String modelPackageArn;
    private String modelApprovalStatus;
    private String approvalDescription;
    private Map<String, String> customerMetadataProperties;
    private List<String> customerMetadataPropertiesToRemove;
    private List<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd;
    private InferenceSpecification inferenceSpecification;
    private String sourceUri;
    private ModelPackageModelCard modelCard;

    public void setModelPackageArn(String modelPackageArn) {
        this.modelPackageArn = modelPackageArn;
    }

    public String getModelPackageArn() {
        return this.modelPackageArn;
    }

    public UpdateModelPackageRequest withModelPackageArn(String modelPackageArn) {
        this.setModelPackageArn(modelPackageArn);
        return this;
    }

    public void setModelApprovalStatus(String modelApprovalStatus) {
        this.modelApprovalStatus = modelApprovalStatus;
    }

    public String getModelApprovalStatus() {
        return this.modelApprovalStatus;
    }

    public UpdateModelPackageRequest withModelApprovalStatus(String modelApprovalStatus) {
        this.setModelApprovalStatus(modelApprovalStatus);
        return this;
    }

    public UpdateModelPackageRequest withModelApprovalStatus(ModelApprovalStatus modelApprovalStatus) {
        this.modelApprovalStatus = modelApprovalStatus.toString();
        return this;
    }

    public void setApprovalDescription(String approvalDescription) {
        this.approvalDescription = approvalDescription;
    }

    public String getApprovalDescription() {
        return this.approvalDescription;
    }

    public UpdateModelPackageRequest withApprovalDescription(String approvalDescription) {
        this.setApprovalDescription(approvalDescription);
        return this;
    }

    public Map<String, String> getCustomerMetadataProperties() {
        return this.customerMetadataProperties;
    }

    public void setCustomerMetadataProperties(Map<String, String> customerMetadataProperties) {
        this.customerMetadataProperties = customerMetadataProperties;
    }

    public UpdateModelPackageRequest withCustomerMetadataProperties(Map<String, String> customerMetadataProperties) {
        this.setCustomerMetadataProperties(customerMetadataProperties);
        return this;
    }

    public UpdateModelPackageRequest addCustomerMetadataPropertiesEntry(String key, String value) {
        if (null == this.customerMetadataProperties) {
            this.customerMetadataProperties = new HashMap<String, String>();
        }
        if (this.customerMetadataProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.customerMetadataProperties.put(key, value);
        return this;
    }

    public UpdateModelPackageRequest clearCustomerMetadataPropertiesEntries() {
        this.customerMetadataProperties = null;
        return this;
    }

    public List<String> getCustomerMetadataPropertiesToRemove() {
        return this.customerMetadataPropertiesToRemove;
    }

    public void setCustomerMetadataPropertiesToRemove(Collection<String> customerMetadataPropertiesToRemove) {
        if (customerMetadataPropertiesToRemove == null) {
            this.customerMetadataPropertiesToRemove = null;
            return;
        }
        this.customerMetadataPropertiesToRemove = new ArrayList<String>(customerMetadataPropertiesToRemove);
    }

    public UpdateModelPackageRequest withCustomerMetadataPropertiesToRemove(String ... customerMetadataPropertiesToRemove) {
        if (this.customerMetadataPropertiesToRemove == null) {
            this.setCustomerMetadataPropertiesToRemove(new ArrayList<String>(customerMetadataPropertiesToRemove.length));
        }
        for (String ele : customerMetadataPropertiesToRemove) {
            this.customerMetadataPropertiesToRemove.add(ele);
        }
        return this;
    }

    public UpdateModelPackageRequest withCustomerMetadataPropertiesToRemove(Collection<String> customerMetadataPropertiesToRemove) {
        this.setCustomerMetadataPropertiesToRemove(customerMetadataPropertiesToRemove);
        return this;
    }

    public List<AdditionalInferenceSpecificationDefinition> getAdditionalInferenceSpecificationsToAdd() {
        return this.additionalInferenceSpecificationsToAdd;
    }

    public void setAdditionalInferenceSpecificationsToAdd(Collection<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd) {
        if (additionalInferenceSpecificationsToAdd == null) {
            this.additionalInferenceSpecificationsToAdd = null;
            return;
        }
        this.additionalInferenceSpecificationsToAdd = new ArrayList<AdditionalInferenceSpecificationDefinition>(additionalInferenceSpecificationsToAdd);
    }

    public UpdateModelPackageRequest withAdditionalInferenceSpecificationsToAdd(AdditionalInferenceSpecificationDefinition ... additionalInferenceSpecificationsToAdd) {
        if (this.additionalInferenceSpecificationsToAdd == null) {
            this.setAdditionalInferenceSpecificationsToAdd(new ArrayList<AdditionalInferenceSpecificationDefinition>(additionalInferenceSpecificationsToAdd.length));
        }
        for (AdditionalInferenceSpecificationDefinition ele : additionalInferenceSpecificationsToAdd) {
            this.additionalInferenceSpecificationsToAdd.add(ele);
        }
        return this;
    }

    public UpdateModelPackageRequest withAdditionalInferenceSpecificationsToAdd(Collection<AdditionalInferenceSpecificationDefinition> additionalInferenceSpecificationsToAdd) {
        this.setAdditionalInferenceSpecificationsToAdd(additionalInferenceSpecificationsToAdd);
        return this;
    }

    public void setInferenceSpecification(InferenceSpecification inferenceSpecification) {
        this.inferenceSpecification = inferenceSpecification;
    }

    public InferenceSpecification getInferenceSpecification() {
        return this.inferenceSpecification;
    }

    public UpdateModelPackageRequest withInferenceSpecification(InferenceSpecification inferenceSpecification) {
        this.setInferenceSpecification(inferenceSpecification);
        return this;
    }

    public void setSourceUri(String sourceUri) {
        this.sourceUri = sourceUri;
    }

    public String getSourceUri() {
        return this.sourceUri;
    }

    public UpdateModelPackageRequest withSourceUri(String sourceUri) {
        this.setSourceUri(sourceUri);
        return this;
    }

    public void setModelCard(ModelPackageModelCard modelCard) {
        this.modelCard = modelCard;
    }

    public ModelPackageModelCard getModelCard() {
        return this.modelCard;
    }

    public UpdateModelPackageRequest withModelCard(ModelPackageModelCard modelCard) {
        this.setModelCard(modelCard);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getModelPackageArn() != null) {
            sb.append("ModelPackageArn: ").append(this.getModelPackageArn()).append(",");
        }
        if (this.getModelApprovalStatus() != null) {
            sb.append("ModelApprovalStatus: ").append(this.getModelApprovalStatus()).append(",");
        }
        if (this.getApprovalDescription() != null) {
            sb.append("ApprovalDescription: ").append(this.getApprovalDescription()).append(",");
        }
        if (this.getCustomerMetadataProperties() != null) {
            sb.append("CustomerMetadataProperties: ").append(this.getCustomerMetadataProperties()).append(",");
        }
        if (this.getCustomerMetadataPropertiesToRemove() != null) {
            sb.append("CustomerMetadataPropertiesToRemove: ").append(this.getCustomerMetadataPropertiesToRemove()).append(",");
        }
        if (this.getAdditionalInferenceSpecificationsToAdd() != null) {
            sb.append("AdditionalInferenceSpecificationsToAdd: ").append(this.getAdditionalInferenceSpecificationsToAdd()).append(",");
        }
        if (this.getInferenceSpecification() != null) {
            sb.append("InferenceSpecification: ").append(this.getInferenceSpecification()).append(",");
        }
        if (this.getSourceUri() != null) {
            sb.append("SourceUri: ").append(this.getSourceUri()).append(",");
        }
        if (this.getModelCard() != null) {
            sb.append("ModelCard: ").append(this.getModelCard());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateModelPackageRequest)) {
            return false;
        }
        UpdateModelPackageRequest other = (UpdateModelPackageRequest)obj;
        if (other.getModelPackageArn() == null ^ this.getModelPackageArn() == null) {
            return false;
        }
        if (other.getModelPackageArn() != null && !other.getModelPackageArn().equals(this.getModelPackageArn())) {
            return false;
        }
        if (other.getModelApprovalStatus() == null ^ this.getModelApprovalStatus() == null) {
            return false;
        }
        if (other.getModelApprovalStatus() != null && !other.getModelApprovalStatus().equals(this.getModelApprovalStatus())) {
            return false;
        }
        if (other.getApprovalDescription() == null ^ this.getApprovalDescription() == null) {
            return false;
        }
        if (other.getApprovalDescription() != null && !other.getApprovalDescription().equals(this.getApprovalDescription())) {
            return false;
        }
        if (other.getCustomerMetadataProperties() == null ^ this.getCustomerMetadataProperties() == null) {
            return false;
        }
        if (other.getCustomerMetadataProperties() != null && !other.getCustomerMetadataProperties().equals(this.getCustomerMetadataProperties())) {
            return false;
        }
        if (other.getCustomerMetadataPropertiesToRemove() == null ^ this.getCustomerMetadataPropertiesToRemove() == null) {
            return false;
        }
        if (other.getCustomerMetadataPropertiesToRemove() != null && !other.getCustomerMetadataPropertiesToRemove().equals(this.getCustomerMetadataPropertiesToRemove())) {
            return false;
        }
        if (other.getAdditionalInferenceSpecificationsToAdd() == null ^ this.getAdditionalInferenceSpecificationsToAdd() == null) {
            return false;
        }
        if (other.getAdditionalInferenceSpecificationsToAdd() != null && !other.getAdditionalInferenceSpecificationsToAdd().equals(this.getAdditionalInferenceSpecificationsToAdd())) {
            return false;
        }
        if (other.getInferenceSpecification() == null ^ this.getInferenceSpecification() == null) {
            return false;
        }
        if (other.getInferenceSpecification() != null && !other.getInferenceSpecification().equals(this.getInferenceSpecification())) {
            return false;
        }
        if (other.getSourceUri() == null ^ this.getSourceUri() == null) {
            return false;
        }
        if (other.getSourceUri() != null && !other.getSourceUri().equals(this.getSourceUri())) {
            return false;
        }
        if (other.getModelCard() == null ^ this.getModelCard() == null) {
            return false;
        }
        return other.getModelCard() == null || other.getModelCard().equals(this.getModelCard());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getModelPackageArn() == null ? 0 : this.getModelPackageArn().hashCode());
        hashCode = 31 * hashCode + (this.getModelApprovalStatus() == null ? 0 : this.getModelApprovalStatus().hashCode());
        hashCode = 31 * hashCode + (this.getApprovalDescription() == null ? 0 : this.getApprovalDescription().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerMetadataProperties() == null ? 0 : this.getCustomerMetadataProperties().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerMetadataPropertiesToRemove() == null ? 0 : this.getCustomerMetadataPropertiesToRemove().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalInferenceSpecificationsToAdd() == null ? 0 : this.getAdditionalInferenceSpecificationsToAdd().hashCode());
        hashCode = 31 * hashCode + (this.getInferenceSpecification() == null ? 0 : this.getInferenceSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getSourceUri() == null ? 0 : this.getSourceUri().hashCode());
        hashCode = 31 * hashCode + (this.getModelCard() == null ? 0 : this.getModelCard().hashCode());
        return hashCode;
    }

    @Override
    public UpdateModelPackageRequest clone() {
        return (UpdateModelPackageRequest)super.clone();
    }
}

