/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.FeatureDefinition;
import com.amazonaws.services.sagemaker.model.OnlineStoreConfigUpdate;
import com.amazonaws.services.sagemaker.model.ThroughputConfigUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateFeatureGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String featureGroupName;
    private List<FeatureDefinition> featureAdditions;
    private OnlineStoreConfigUpdate onlineStoreConfig;
    private ThroughputConfigUpdate throughputConfig;

    public void setFeatureGroupName(String featureGroupName) {
        this.featureGroupName = featureGroupName;
    }

    public String getFeatureGroupName() {
        return this.featureGroupName;
    }

    public UpdateFeatureGroupRequest withFeatureGroupName(String featureGroupName) {
        this.setFeatureGroupName(featureGroupName);
        return this;
    }

    public List<FeatureDefinition> getFeatureAdditions() {
        return this.featureAdditions;
    }

    public void setFeatureAdditions(Collection<FeatureDefinition> featureAdditions) {
        if (featureAdditions == null) {
            this.featureAdditions = null;
            return;
        }
        this.featureAdditions = new ArrayList<FeatureDefinition>(featureAdditions);
    }

    public UpdateFeatureGroupRequest withFeatureAdditions(FeatureDefinition ... featureAdditions) {
        if (this.featureAdditions == null) {
            this.setFeatureAdditions(new ArrayList<FeatureDefinition>(featureAdditions.length));
        }
        for (FeatureDefinition ele : featureAdditions) {
            this.featureAdditions.add(ele);
        }
        return this;
    }

    public UpdateFeatureGroupRequest withFeatureAdditions(Collection<FeatureDefinition> featureAdditions) {
        this.setFeatureAdditions(featureAdditions);
        return this;
    }

    public void setOnlineStoreConfig(OnlineStoreConfigUpdate onlineStoreConfig) {
        this.onlineStoreConfig = onlineStoreConfig;
    }

    public OnlineStoreConfigUpdate getOnlineStoreConfig() {
        return this.onlineStoreConfig;
    }

    public UpdateFeatureGroupRequest withOnlineStoreConfig(OnlineStoreConfigUpdate onlineStoreConfig) {
        this.setOnlineStoreConfig(onlineStoreConfig);
        return this;
    }

    public void setThroughputConfig(ThroughputConfigUpdate throughputConfig) {
        this.throughputConfig = throughputConfig;
    }

    public ThroughputConfigUpdate getThroughputConfig() {
        return this.throughputConfig;
    }

    public UpdateFeatureGroupRequest withThroughputConfig(ThroughputConfigUpdate throughputConfig) {
        this.setThroughputConfig(throughputConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFeatureGroupName() != null) {
            sb.append("FeatureGroupName: ").append(this.getFeatureGroupName()).append(",");
        }
        if (this.getFeatureAdditions() != null) {
            sb.append("FeatureAdditions: ").append(this.getFeatureAdditions()).append(",");
        }
        if (this.getOnlineStoreConfig() != null) {
            sb.append("OnlineStoreConfig: ").append(this.getOnlineStoreConfig()).append(",");
        }
        if (this.getThroughputConfig() != null) {
            sb.append("ThroughputConfig: ").append(this.getThroughputConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFeatureGroupRequest)) {
            return false;
        }
        UpdateFeatureGroupRequest other = (UpdateFeatureGroupRequest)obj;
        if (other.getFeatureGroupName() == null ^ this.getFeatureGroupName() == null) {
            return false;
        }
        if (other.getFeatureGroupName() != null && !other.getFeatureGroupName().equals(this.getFeatureGroupName())) {
            return false;
        }
        if (other.getFeatureAdditions() == null ^ this.getFeatureAdditions() == null) {
            return false;
        }
        if (other.getFeatureAdditions() != null && !other.getFeatureAdditions().equals(this.getFeatureAdditions())) {
            return false;
        }
        if (other.getOnlineStoreConfig() == null ^ this.getOnlineStoreConfig() == null) {
            return false;
        }
        if (other.getOnlineStoreConfig() != null && !other.getOnlineStoreConfig().equals(this.getOnlineStoreConfig())) {
            return false;
        }
        if (other.getThroughputConfig() == null ^ this.getThroughputConfig() == null) {
            return false;
        }
        return other.getThroughputConfig() == null || other.getThroughputConfig().equals(this.getThroughputConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFeatureGroupName() == null ? 0 : this.getFeatureGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getFeatureAdditions() == null ? 0 : this.getFeatureAdditions().hashCode());
        hashCode = 31 * hashCode + (this.getOnlineStoreConfig() == null ? 0 : this.getOnlineStoreConfig().hashCode());
        hashCode = 31 * hashCode + (this.getThroughputConfig() == null ? 0 : this.getThroughputConfig().hashCode());
        return hashCode;
    }

    @Override
    public UpdateFeatureGroupRequest clone() {
        return (UpdateFeatureGroupRequest)super.clone();
    }
}

