/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateContextRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String contextName;
    private String description;
    private Map<String, String> properties;
    private List<String> propertiesToRemove;

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public UpdateContextRequest withContextName(String contextName) {
        this.setContextName(contextName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateContextRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public UpdateContextRequest withProperties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public UpdateContextRequest addPropertiesEntry(String key, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public UpdateContextRequest clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public List<String> getPropertiesToRemove() {
        return this.propertiesToRemove;
    }

    public void setPropertiesToRemove(Collection<String> propertiesToRemove) {
        if (propertiesToRemove == null) {
            this.propertiesToRemove = null;
            return;
        }
        this.propertiesToRemove = new ArrayList<String>(propertiesToRemove);
    }

    public UpdateContextRequest withPropertiesToRemove(String ... propertiesToRemove) {
        if (this.propertiesToRemove == null) {
            this.setPropertiesToRemove(new ArrayList<String>(propertiesToRemove.length));
        }
        for (String ele : propertiesToRemove) {
            this.propertiesToRemove.add(ele);
        }
        return this;
    }

    public UpdateContextRequest withPropertiesToRemove(Collection<String> propertiesToRemove) {
        this.setPropertiesToRemove(propertiesToRemove);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContextName() != null) {
            sb.append("ContextName: ").append(this.getContextName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getPropertiesToRemove() != null) {
            sb.append("PropertiesToRemove: ").append(this.getPropertiesToRemove());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContextRequest)) {
            return false;
        }
        UpdateContextRequest other = (UpdateContextRequest)obj;
        if (other.getContextName() == null ^ this.getContextName() == null) {
            return false;
        }
        if (other.getContextName() != null && !other.getContextName().equals(this.getContextName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getPropertiesToRemove() == null ^ this.getPropertiesToRemove() == null) {
            return false;
        }
        return other.getPropertiesToRemove() == null || other.getPropertiesToRemove().equals(this.getPropertiesToRemove());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContextName() == null ? 0 : this.getContextName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getPropertiesToRemove() == null ? 0 : this.getPropertiesToRemove().hashCode());
        return hashCode;
    }

    @Override
    public UpdateContextRequest clone() {
        return (UpdateContextRequest)super.clone();
    }
}

