/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateArtifactRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String artifactArn;
    private String artifactName;
    private Map<String, String> properties;
    private List<String> propertiesToRemove;

    public void setArtifactArn(String artifactArn) {
        this.artifactArn = artifactArn;
    }

    public String getArtifactArn() {
        return this.artifactArn;
    }

    public UpdateArtifactRequest withArtifactArn(String artifactArn) {
        this.setArtifactArn(artifactArn);
        return this;
    }

    public void setArtifactName(String artifactName) {
        this.artifactName = artifactName;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public UpdateArtifactRequest withArtifactName(String artifactName) {
        this.setArtifactName(artifactName);
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public UpdateArtifactRequest withProperties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public UpdateArtifactRequest addPropertiesEntry(String key, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public UpdateArtifactRequest clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public List<String> getPropertiesToRemove() {
        return this.propertiesToRemove;
    }

    public void setPropertiesToRemove(Collection<String> propertiesToRemove) {
        if (propertiesToRemove == null) {
            this.propertiesToRemove = null;
            return;
        }
        this.propertiesToRemove = new ArrayList<String>(propertiesToRemove);
    }

    public UpdateArtifactRequest withPropertiesToRemove(String ... propertiesToRemove) {
        if (this.propertiesToRemove == null) {
            this.setPropertiesToRemove(new ArrayList<String>(propertiesToRemove.length));
        }
        for (String ele : propertiesToRemove) {
            this.propertiesToRemove.add(ele);
        }
        return this;
    }

    public UpdateArtifactRequest withPropertiesToRemove(Collection<String> propertiesToRemove) {
        this.setPropertiesToRemove(propertiesToRemove);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArtifactArn() != null) {
            sb.append("ArtifactArn: ").append(this.getArtifactArn()).append(",");
        }
        if (this.getArtifactName() != null) {
            sb.append("ArtifactName: ").append(this.getArtifactName()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getPropertiesToRemove() != null) {
            sb.append("PropertiesToRemove: ").append(this.getPropertiesToRemove());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateArtifactRequest)) {
            return false;
        }
        UpdateArtifactRequest other = (UpdateArtifactRequest)obj;
        if (other.getArtifactArn() == null ^ this.getArtifactArn() == null) {
            return false;
        }
        if (other.getArtifactArn() != null && !other.getArtifactArn().equals(this.getArtifactArn())) {
            return false;
        }
        if (other.getArtifactName() == null ^ this.getArtifactName() == null) {
            return false;
        }
        if (other.getArtifactName() != null && !other.getArtifactName().equals(this.getArtifactName())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getPropertiesToRemove() == null ^ this.getPropertiesToRemove() == null) {
            return false;
        }
        return other.getPropertiesToRemove() == null || other.getPropertiesToRemove().equals(this.getPropertiesToRemove());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArtifactArn() == null ? 0 : this.getArtifactArn().hashCode());
        hashCode = 31 * hashCode + (this.getArtifactName() == null ? 0 : this.getArtifactName().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getPropertiesToRemove() == null ? 0 : this.getPropertiesToRemove().hashCode());
        return hashCode;
    }

    @Override
    public UpdateArtifactRequest clone() {
        return (UpdateArtifactRequest)super.clone();
    }
}

