/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.CompressionType;
import com.amazonaws.services.sagemaker.model.SplitType;
import com.amazonaws.services.sagemaker.model.TransformDataSource;
import com.amazonaws.services.sagemaker.model.transform.TransformInputMarshaller;
import java.io.Serializable;

public class TransformInput
implements Serializable,
Cloneable,
StructuredPojo {
    private TransformDataSource dataSource;
    private String contentType;
    private String compressionType;
    private String splitType;

    public void setDataSource(TransformDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public TransformDataSource getDataSource() {
        return this.dataSource;
    }

    public TransformInput withDataSource(TransformDataSource dataSource) {
        this.setDataSource(dataSource);
        return this;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public TransformInput withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public TransformInput withCompressionType(String compressionType) {
        this.setCompressionType(compressionType);
        return this;
    }

    public TransformInput withCompressionType(CompressionType compressionType) {
        this.compressionType = compressionType.toString();
        return this;
    }

    public void setSplitType(String splitType) {
        this.splitType = splitType;
    }

    public String getSplitType() {
        return this.splitType;
    }

    public TransformInput withSplitType(String splitType) {
        this.setSplitType(splitType);
        return this;
    }

    public TransformInput withSplitType(SplitType splitType) {
        this.splitType = splitType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataSource() != null) {
            sb.append("DataSource: ").append(this.getDataSource()).append(",");
        }
        if (this.getContentType() != null) {
            sb.append("ContentType: ").append(this.getContentType()).append(",");
        }
        if (this.getCompressionType() != null) {
            sb.append("CompressionType: ").append(this.getCompressionType()).append(",");
        }
        if (this.getSplitType() != null) {
            sb.append("SplitType: ").append(this.getSplitType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformInput)) {
            return false;
        }
        TransformInput other = (TransformInput)obj;
        if (other.getDataSource() == null ^ this.getDataSource() == null) {
            return false;
        }
        if (other.getDataSource() != null && !other.getDataSource().equals(this.getDataSource())) {
            return false;
        }
        if (other.getContentType() == null ^ this.getContentType() == null) {
            return false;
        }
        if (other.getContentType() != null && !other.getContentType().equals(this.getContentType())) {
            return false;
        }
        if (other.getCompressionType() == null ^ this.getCompressionType() == null) {
            return false;
        }
        if (other.getCompressionType() != null && !other.getCompressionType().equals(this.getCompressionType())) {
            return false;
        }
        if (other.getSplitType() == null ^ this.getSplitType() == null) {
            return false;
        }
        return other.getSplitType() == null || other.getSplitType().equals(this.getSplitType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataSource() == null ? 0 : this.getDataSource().hashCode());
        hashCode = 31 * hashCode + (this.getContentType() == null ? 0 : this.getContentType().hashCode());
        hashCode = 31 * hashCode + (this.getCompressionType() == null ? 0 : this.getCompressionType().hashCode());
        hashCode = 31 * hashCode + (this.getSplitType() == null ? 0 : this.getSplitType().hashCode());
        return hashCode;
    }

    public TransformInput clone() {
        try {
            return (TransformInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TransformInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

