/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.AdditionalS3DataSource;
import com.amazonaws.services.sagemaker.model.ChannelSpecification;
import com.amazonaws.services.sagemaker.model.HyperParameterSpecification;
import com.amazonaws.services.sagemaker.model.HyperParameterTuningJobObjective;
import com.amazonaws.services.sagemaker.model.MetricDefinition;
import com.amazonaws.services.sagemaker.model.TrainingInstanceType;
import com.amazonaws.services.sagemaker.model.transform.TrainingSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TrainingSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String trainingImage;
    private String trainingImageDigest;
    private List<HyperParameterSpecification> supportedHyperParameters;
    private List<String> supportedTrainingInstanceTypes;
    private Boolean supportsDistributedTraining;
    private List<MetricDefinition> metricDefinitions;
    private List<ChannelSpecification> trainingChannels;
    private List<HyperParameterTuningJobObjective> supportedTuningJobObjectiveMetrics;
    private AdditionalS3DataSource additionalS3DataSource;

    public void setTrainingImage(String trainingImage) {
        this.trainingImage = trainingImage;
    }

    public String getTrainingImage() {
        return this.trainingImage;
    }

    public TrainingSpecification withTrainingImage(String trainingImage) {
        this.setTrainingImage(trainingImage);
        return this;
    }

    public void setTrainingImageDigest(String trainingImageDigest) {
        this.trainingImageDigest = trainingImageDigest;
    }

    public String getTrainingImageDigest() {
        return this.trainingImageDigest;
    }

    public TrainingSpecification withTrainingImageDigest(String trainingImageDigest) {
        this.setTrainingImageDigest(trainingImageDigest);
        return this;
    }

    public List<HyperParameterSpecification> getSupportedHyperParameters() {
        return this.supportedHyperParameters;
    }

    public void setSupportedHyperParameters(Collection<HyperParameterSpecification> supportedHyperParameters) {
        if (supportedHyperParameters == null) {
            this.supportedHyperParameters = null;
            return;
        }
        this.supportedHyperParameters = new ArrayList<HyperParameterSpecification>(supportedHyperParameters);
    }

    public TrainingSpecification withSupportedHyperParameters(HyperParameterSpecification ... supportedHyperParameters) {
        if (this.supportedHyperParameters == null) {
            this.setSupportedHyperParameters(new ArrayList<HyperParameterSpecification>(supportedHyperParameters.length));
        }
        for (HyperParameterSpecification ele : supportedHyperParameters) {
            this.supportedHyperParameters.add(ele);
        }
        return this;
    }

    public TrainingSpecification withSupportedHyperParameters(Collection<HyperParameterSpecification> supportedHyperParameters) {
        this.setSupportedHyperParameters(supportedHyperParameters);
        return this;
    }

    public List<String> getSupportedTrainingInstanceTypes() {
        return this.supportedTrainingInstanceTypes;
    }

    public void setSupportedTrainingInstanceTypes(Collection<String> supportedTrainingInstanceTypes) {
        if (supportedTrainingInstanceTypes == null) {
            this.supportedTrainingInstanceTypes = null;
            return;
        }
        this.supportedTrainingInstanceTypes = new ArrayList<String>(supportedTrainingInstanceTypes);
    }

    public TrainingSpecification withSupportedTrainingInstanceTypes(String ... supportedTrainingInstanceTypes) {
        if (this.supportedTrainingInstanceTypes == null) {
            this.setSupportedTrainingInstanceTypes(new ArrayList<String>(supportedTrainingInstanceTypes.length));
        }
        for (String ele : supportedTrainingInstanceTypes) {
            this.supportedTrainingInstanceTypes.add(ele);
        }
        return this;
    }

    public TrainingSpecification withSupportedTrainingInstanceTypes(Collection<String> supportedTrainingInstanceTypes) {
        this.setSupportedTrainingInstanceTypes(supportedTrainingInstanceTypes);
        return this;
    }

    public TrainingSpecification withSupportedTrainingInstanceTypes(TrainingInstanceType ... supportedTrainingInstanceTypes) {
        ArrayList<String> supportedTrainingInstanceTypesCopy = new ArrayList<String>(supportedTrainingInstanceTypes.length);
        for (TrainingInstanceType value : supportedTrainingInstanceTypes) {
            supportedTrainingInstanceTypesCopy.add(value.toString());
        }
        if (this.getSupportedTrainingInstanceTypes() == null) {
            this.setSupportedTrainingInstanceTypes(supportedTrainingInstanceTypesCopy);
        } else {
            this.getSupportedTrainingInstanceTypes().addAll(supportedTrainingInstanceTypesCopy);
        }
        return this;
    }

    public void setSupportsDistributedTraining(Boolean supportsDistributedTraining) {
        this.supportsDistributedTraining = supportsDistributedTraining;
    }

    public Boolean getSupportsDistributedTraining() {
        return this.supportsDistributedTraining;
    }

    public TrainingSpecification withSupportsDistributedTraining(Boolean supportsDistributedTraining) {
        this.setSupportsDistributedTraining(supportsDistributedTraining);
        return this;
    }

    public Boolean isSupportsDistributedTraining() {
        return this.supportsDistributedTraining;
    }

    public List<MetricDefinition> getMetricDefinitions() {
        return this.metricDefinitions;
    }

    public void setMetricDefinitions(Collection<MetricDefinition> metricDefinitions) {
        if (metricDefinitions == null) {
            this.metricDefinitions = null;
            return;
        }
        this.metricDefinitions = new ArrayList<MetricDefinition>(metricDefinitions);
    }

    public TrainingSpecification withMetricDefinitions(MetricDefinition ... metricDefinitions) {
        if (this.metricDefinitions == null) {
            this.setMetricDefinitions(new ArrayList<MetricDefinition>(metricDefinitions.length));
        }
        for (MetricDefinition ele : metricDefinitions) {
            this.metricDefinitions.add(ele);
        }
        return this;
    }

    public TrainingSpecification withMetricDefinitions(Collection<MetricDefinition> metricDefinitions) {
        this.setMetricDefinitions(metricDefinitions);
        return this;
    }

    public List<ChannelSpecification> getTrainingChannels() {
        return this.trainingChannels;
    }

    public void setTrainingChannels(Collection<ChannelSpecification> trainingChannels) {
        if (trainingChannels == null) {
            this.trainingChannels = null;
            return;
        }
        this.trainingChannels = new ArrayList<ChannelSpecification>(trainingChannels);
    }

    public TrainingSpecification withTrainingChannels(ChannelSpecification ... trainingChannels) {
        if (this.trainingChannels == null) {
            this.setTrainingChannels(new ArrayList<ChannelSpecification>(trainingChannels.length));
        }
        for (ChannelSpecification ele : trainingChannels) {
            this.trainingChannels.add(ele);
        }
        return this;
    }

    public TrainingSpecification withTrainingChannels(Collection<ChannelSpecification> trainingChannels) {
        this.setTrainingChannels(trainingChannels);
        return this;
    }

    public List<HyperParameterTuningJobObjective> getSupportedTuningJobObjectiveMetrics() {
        return this.supportedTuningJobObjectiveMetrics;
    }

    public void setSupportedTuningJobObjectiveMetrics(Collection<HyperParameterTuningJobObjective> supportedTuningJobObjectiveMetrics) {
        if (supportedTuningJobObjectiveMetrics == null) {
            this.supportedTuningJobObjectiveMetrics = null;
            return;
        }
        this.supportedTuningJobObjectiveMetrics = new ArrayList<HyperParameterTuningJobObjective>(supportedTuningJobObjectiveMetrics);
    }

    public TrainingSpecification withSupportedTuningJobObjectiveMetrics(HyperParameterTuningJobObjective ... supportedTuningJobObjectiveMetrics) {
        if (this.supportedTuningJobObjectiveMetrics == null) {
            this.setSupportedTuningJobObjectiveMetrics(new ArrayList<HyperParameterTuningJobObjective>(supportedTuningJobObjectiveMetrics.length));
        }
        for (HyperParameterTuningJobObjective ele : supportedTuningJobObjectiveMetrics) {
            this.supportedTuningJobObjectiveMetrics.add(ele);
        }
        return this;
    }

    public TrainingSpecification withSupportedTuningJobObjectiveMetrics(Collection<HyperParameterTuningJobObjective> supportedTuningJobObjectiveMetrics) {
        this.setSupportedTuningJobObjectiveMetrics(supportedTuningJobObjectiveMetrics);
        return this;
    }

    public void setAdditionalS3DataSource(AdditionalS3DataSource additionalS3DataSource) {
        this.additionalS3DataSource = additionalS3DataSource;
    }

    public AdditionalS3DataSource getAdditionalS3DataSource() {
        return this.additionalS3DataSource;
    }

    public TrainingSpecification withAdditionalS3DataSource(AdditionalS3DataSource additionalS3DataSource) {
        this.setAdditionalS3DataSource(additionalS3DataSource);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrainingImage() != null) {
            sb.append("TrainingImage: ").append(this.getTrainingImage()).append(",");
        }
        if (this.getTrainingImageDigest() != null) {
            sb.append("TrainingImageDigest: ").append(this.getTrainingImageDigest()).append(",");
        }
        if (this.getSupportedHyperParameters() != null) {
            sb.append("SupportedHyperParameters: ").append(this.getSupportedHyperParameters()).append(",");
        }
        if (this.getSupportedTrainingInstanceTypes() != null) {
            sb.append("SupportedTrainingInstanceTypes: ").append(this.getSupportedTrainingInstanceTypes()).append(",");
        }
        if (this.getSupportsDistributedTraining() != null) {
            sb.append("SupportsDistributedTraining: ").append(this.getSupportsDistributedTraining()).append(",");
        }
        if (this.getMetricDefinitions() != null) {
            sb.append("MetricDefinitions: ").append(this.getMetricDefinitions()).append(",");
        }
        if (this.getTrainingChannels() != null) {
            sb.append("TrainingChannels: ").append(this.getTrainingChannels()).append(",");
        }
        if (this.getSupportedTuningJobObjectiveMetrics() != null) {
            sb.append("SupportedTuningJobObjectiveMetrics: ").append(this.getSupportedTuningJobObjectiveMetrics()).append(",");
        }
        if (this.getAdditionalS3DataSource() != null) {
            sb.append("AdditionalS3DataSource: ").append(this.getAdditionalS3DataSource());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingSpecification)) {
            return false;
        }
        TrainingSpecification other = (TrainingSpecification)obj;
        if (other.getTrainingImage() == null ^ this.getTrainingImage() == null) {
            return false;
        }
        if (other.getTrainingImage() != null && !other.getTrainingImage().equals(this.getTrainingImage())) {
            return false;
        }
        if (other.getTrainingImageDigest() == null ^ this.getTrainingImageDigest() == null) {
            return false;
        }
        if (other.getTrainingImageDigest() != null && !other.getTrainingImageDigest().equals(this.getTrainingImageDigest())) {
            return false;
        }
        if (other.getSupportedHyperParameters() == null ^ this.getSupportedHyperParameters() == null) {
            return false;
        }
        if (other.getSupportedHyperParameters() != null && !other.getSupportedHyperParameters().equals(this.getSupportedHyperParameters())) {
            return false;
        }
        if (other.getSupportedTrainingInstanceTypes() == null ^ this.getSupportedTrainingInstanceTypes() == null) {
            return false;
        }
        if (other.getSupportedTrainingInstanceTypes() != null && !other.getSupportedTrainingInstanceTypes().equals(this.getSupportedTrainingInstanceTypes())) {
            return false;
        }
        if (other.getSupportsDistributedTraining() == null ^ this.getSupportsDistributedTraining() == null) {
            return false;
        }
        if (other.getSupportsDistributedTraining() != null && !other.getSupportsDistributedTraining().equals(this.getSupportsDistributedTraining())) {
            return false;
        }
        if (other.getMetricDefinitions() == null ^ this.getMetricDefinitions() == null) {
            return false;
        }
        if (other.getMetricDefinitions() != null && !other.getMetricDefinitions().equals(this.getMetricDefinitions())) {
            return false;
        }
        if (other.getTrainingChannels() == null ^ this.getTrainingChannels() == null) {
            return false;
        }
        if (other.getTrainingChannels() != null && !other.getTrainingChannels().equals(this.getTrainingChannels())) {
            return false;
        }
        if (other.getSupportedTuningJobObjectiveMetrics() == null ^ this.getSupportedTuningJobObjectiveMetrics() == null) {
            return false;
        }
        if (other.getSupportedTuningJobObjectiveMetrics() != null && !other.getSupportedTuningJobObjectiveMetrics().equals(this.getSupportedTuningJobObjectiveMetrics())) {
            return false;
        }
        if (other.getAdditionalS3DataSource() == null ^ this.getAdditionalS3DataSource() == null) {
            return false;
        }
        return other.getAdditionalS3DataSource() == null || other.getAdditionalS3DataSource().equals(this.getAdditionalS3DataSource());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrainingImage() == null ? 0 : this.getTrainingImage().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingImageDigest() == null ? 0 : this.getTrainingImageDigest().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedHyperParameters() == null ? 0 : this.getSupportedHyperParameters().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedTrainingInstanceTypes() == null ? 0 : this.getSupportedTrainingInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportsDistributedTraining() == null ? 0 : this.getSupportsDistributedTraining().hashCode());
        hashCode = 31 * hashCode + (this.getMetricDefinitions() == null ? 0 : this.getMetricDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingChannels() == null ? 0 : this.getTrainingChannels().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedTuningJobObjectiveMetrics() == null ? 0 : this.getSupportedTuningJobObjectiveMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalS3DataSource() == null ? 0 : this.getAdditionalS3DataSource().hashCode());
        return hashCode;
    }

    public TrainingSpecification clone() {
        try {
            return (TrainingSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrainingSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

