/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.Channel;
import com.amazonaws.services.sagemaker.model.OutputDataConfig;
import com.amazonaws.services.sagemaker.model.ResourceConfig;
import com.amazonaws.services.sagemaker.model.StoppingCondition;
import com.amazonaws.services.sagemaker.model.TrainingInputMode;
import com.amazonaws.services.sagemaker.model.transform.TrainingJobDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrainingJobDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String trainingInputMode;
    private Map<String, String> hyperParameters;
    private List<Channel> inputDataConfig;
    private OutputDataConfig outputDataConfig;
    private ResourceConfig resourceConfig;
    private StoppingCondition stoppingCondition;

    public void setTrainingInputMode(String trainingInputMode) {
        this.trainingInputMode = trainingInputMode;
    }

    public String getTrainingInputMode() {
        return this.trainingInputMode;
    }

    public TrainingJobDefinition withTrainingInputMode(String trainingInputMode) {
        this.setTrainingInputMode(trainingInputMode);
        return this;
    }

    public TrainingJobDefinition withTrainingInputMode(TrainingInputMode trainingInputMode) {
        this.trainingInputMode = trainingInputMode.toString();
        return this;
    }

    public Map<String, String> getHyperParameters() {
        return this.hyperParameters;
    }

    public void setHyperParameters(Map<String, String> hyperParameters) {
        this.hyperParameters = hyperParameters;
    }

    public TrainingJobDefinition withHyperParameters(Map<String, String> hyperParameters) {
        this.setHyperParameters(hyperParameters);
        return this;
    }

    public TrainingJobDefinition addHyperParametersEntry(String key, String value) {
        if (null == this.hyperParameters) {
            this.hyperParameters = new HashMap<String, String>();
        }
        if (this.hyperParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.hyperParameters.put(key, value);
        return this;
    }

    public TrainingJobDefinition clearHyperParametersEntries() {
        this.hyperParameters = null;
        return this;
    }

    public List<Channel> getInputDataConfig() {
        return this.inputDataConfig;
    }

    public void setInputDataConfig(Collection<Channel> inputDataConfig) {
        if (inputDataConfig == null) {
            this.inputDataConfig = null;
            return;
        }
        this.inputDataConfig = new ArrayList<Channel>(inputDataConfig);
    }

    public TrainingJobDefinition withInputDataConfig(Channel ... inputDataConfig) {
        if (this.inputDataConfig == null) {
            this.setInputDataConfig(new ArrayList<Channel>(inputDataConfig.length));
        }
        for (Channel ele : inputDataConfig) {
            this.inputDataConfig.add(ele);
        }
        return this;
    }

    public TrainingJobDefinition withInputDataConfig(Collection<Channel> inputDataConfig) {
        this.setInputDataConfig(inputDataConfig);
        return this;
    }

    public void setOutputDataConfig(OutputDataConfig outputDataConfig) {
        this.outputDataConfig = outputDataConfig;
    }

    public OutputDataConfig getOutputDataConfig() {
        return this.outputDataConfig;
    }

    public TrainingJobDefinition withOutputDataConfig(OutputDataConfig outputDataConfig) {
        this.setOutputDataConfig(outputDataConfig);
        return this;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public TrainingJobDefinition withResourceConfig(ResourceConfig resourceConfig) {
        this.setResourceConfig(resourceConfig);
        return this;
    }

    public void setStoppingCondition(StoppingCondition stoppingCondition) {
        this.stoppingCondition = stoppingCondition;
    }

    public StoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    public TrainingJobDefinition withStoppingCondition(StoppingCondition stoppingCondition) {
        this.setStoppingCondition(stoppingCondition);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrainingInputMode() != null) {
            sb.append("TrainingInputMode: ").append(this.getTrainingInputMode()).append(",");
        }
        if (this.getHyperParameters() != null) {
            sb.append("HyperParameters: ").append(this.getHyperParameters()).append(",");
        }
        if (this.getInputDataConfig() != null) {
            sb.append("InputDataConfig: ").append(this.getInputDataConfig()).append(",");
        }
        if (this.getOutputDataConfig() != null) {
            sb.append("OutputDataConfig: ").append(this.getOutputDataConfig()).append(",");
        }
        if (this.getResourceConfig() != null) {
            sb.append("ResourceConfig: ").append(this.getResourceConfig()).append(",");
        }
        if (this.getStoppingCondition() != null) {
            sb.append("StoppingCondition: ").append(this.getStoppingCondition());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingJobDefinition)) {
            return false;
        }
        TrainingJobDefinition other = (TrainingJobDefinition)obj;
        if (other.getTrainingInputMode() == null ^ this.getTrainingInputMode() == null) {
            return false;
        }
        if (other.getTrainingInputMode() != null && !other.getTrainingInputMode().equals(this.getTrainingInputMode())) {
            return false;
        }
        if (other.getHyperParameters() == null ^ this.getHyperParameters() == null) {
            return false;
        }
        if (other.getHyperParameters() != null && !other.getHyperParameters().equals(this.getHyperParameters())) {
            return false;
        }
        if (other.getInputDataConfig() == null ^ this.getInputDataConfig() == null) {
            return false;
        }
        if (other.getInputDataConfig() != null && !other.getInputDataConfig().equals(this.getInputDataConfig())) {
            return false;
        }
        if (other.getOutputDataConfig() == null ^ this.getOutputDataConfig() == null) {
            return false;
        }
        if (other.getOutputDataConfig() != null && !other.getOutputDataConfig().equals(this.getOutputDataConfig())) {
            return false;
        }
        if (other.getResourceConfig() == null ^ this.getResourceConfig() == null) {
            return false;
        }
        if (other.getResourceConfig() != null && !other.getResourceConfig().equals(this.getResourceConfig())) {
            return false;
        }
        if (other.getStoppingCondition() == null ^ this.getStoppingCondition() == null) {
            return false;
        }
        return other.getStoppingCondition() == null || other.getStoppingCondition().equals(this.getStoppingCondition());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrainingInputMode() == null ? 0 : this.getTrainingInputMode().hashCode());
        hashCode = 31 * hashCode + (this.getHyperParameters() == null ? 0 : this.getHyperParameters().hashCode());
        hashCode = 31 * hashCode + (this.getInputDataConfig() == null ? 0 : this.getInputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getOutputDataConfig() == null ? 0 : this.getOutputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getResourceConfig() == null ? 0 : this.getResourceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getStoppingCondition() == null ? 0 : this.getStoppingCondition().hashCode());
        return hashCode;
    }

    public TrainingJobDefinition clone() {
        try {
            return (TrainingJobDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrainingJobDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

