/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.Phase;
import com.amazonaws.services.sagemaker.model.Stairs;
import com.amazonaws.services.sagemaker.model.TrafficType;
import com.amazonaws.services.sagemaker.model.transform.TrafficPatternMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TrafficPattern
implements Serializable,
Cloneable,
StructuredPojo {
    private String trafficType;
    private List<Phase> phases;
    private Stairs stairs;

    public void setTrafficType(String trafficType) {
        this.trafficType = trafficType;
    }

    public String getTrafficType() {
        return this.trafficType;
    }

    public TrafficPattern withTrafficType(String trafficType) {
        this.setTrafficType(trafficType);
        return this;
    }

    public TrafficPattern withTrafficType(TrafficType trafficType) {
        this.trafficType = trafficType.toString();
        return this;
    }

    public List<Phase> getPhases() {
        return this.phases;
    }

    public void setPhases(Collection<Phase> phases) {
        if (phases == null) {
            this.phases = null;
            return;
        }
        this.phases = new ArrayList<Phase>(phases);
    }

    public TrafficPattern withPhases(Phase ... phases) {
        if (this.phases == null) {
            this.setPhases(new ArrayList<Phase>(phases.length));
        }
        for (Phase ele : phases) {
            this.phases.add(ele);
        }
        return this;
    }

    public TrafficPattern withPhases(Collection<Phase> phases) {
        this.setPhases(phases);
        return this;
    }

    public void setStairs(Stairs stairs) {
        this.stairs = stairs;
    }

    public Stairs getStairs() {
        return this.stairs;
    }

    public TrafficPattern withStairs(Stairs stairs) {
        this.setStairs(stairs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrafficType() != null) {
            sb.append("TrafficType: ").append(this.getTrafficType()).append(",");
        }
        if (this.getPhases() != null) {
            sb.append("Phases: ").append(this.getPhases()).append(",");
        }
        if (this.getStairs() != null) {
            sb.append("Stairs: ").append(this.getStairs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficPattern)) {
            return false;
        }
        TrafficPattern other = (TrafficPattern)obj;
        if (other.getTrafficType() == null ^ this.getTrafficType() == null) {
            return false;
        }
        if (other.getTrafficType() != null && !other.getTrafficType().equals(this.getTrafficType())) {
            return false;
        }
        if (other.getPhases() == null ^ this.getPhases() == null) {
            return false;
        }
        if (other.getPhases() != null && !other.getPhases().equals(this.getPhases())) {
            return false;
        }
        if (other.getStairs() == null ^ this.getStairs() == null) {
            return false;
        }
        return other.getStairs() == null || other.getStairs().equals(this.getStairs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrafficType() == null ? 0 : this.getTrafficType().hashCode());
        hashCode = 31 * hashCode + (this.getPhases() == null ? 0 : this.getPhases().hashCode());
        hashCode = 31 * hashCode + (this.getStairs() == null ? 0 : this.getStairs().hashCode());
        return hashCode;
    }

    public TrafficPattern clone() {
        try {
            return (TrafficPattern)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrafficPatternMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

