/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.AppType;
import com.amazonaws.services.sagemaker.model.CustomFileSystem;
import com.amazonaws.services.sagemaker.model.JupyterServerAppSettings;
import com.amazonaws.services.sagemaker.model.KernelGatewayAppSettings;
import com.amazonaws.services.sagemaker.model.SpaceCodeEditorAppSettings;
import com.amazonaws.services.sagemaker.model.SpaceJupyterLabAppSettings;
import com.amazonaws.services.sagemaker.model.SpaceStorageSettings;
import com.amazonaws.services.sagemaker.model.transform.SpaceSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SpaceSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private JupyterServerAppSettings jupyterServerAppSettings;
    private KernelGatewayAppSettings kernelGatewayAppSettings;
    private SpaceCodeEditorAppSettings codeEditorAppSettings;
    private SpaceJupyterLabAppSettings jupyterLabAppSettings;
    private String appType;
    private SpaceStorageSettings spaceStorageSettings;
    private List<CustomFileSystem> customFileSystems;

    public void setJupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
        this.jupyterServerAppSettings = jupyterServerAppSettings;
    }

    public JupyterServerAppSettings getJupyterServerAppSettings() {
        return this.jupyterServerAppSettings;
    }

    public SpaceSettings withJupyterServerAppSettings(JupyterServerAppSettings jupyterServerAppSettings) {
        this.setJupyterServerAppSettings(jupyterServerAppSettings);
        return this;
    }

    public void setKernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
        this.kernelGatewayAppSettings = kernelGatewayAppSettings;
    }

    public KernelGatewayAppSettings getKernelGatewayAppSettings() {
        return this.kernelGatewayAppSettings;
    }

    public SpaceSettings withKernelGatewayAppSettings(KernelGatewayAppSettings kernelGatewayAppSettings) {
        this.setKernelGatewayAppSettings(kernelGatewayAppSettings);
        return this;
    }

    public void setCodeEditorAppSettings(SpaceCodeEditorAppSettings codeEditorAppSettings) {
        this.codeEditorAppSettings = codeEditorAppSettings;
    }

    public SpaceCodeEditorAppSettings getCodeEditorAppSettings() {
        return this.codeEditorAppSettings;
    }

    public SpaceSettings withCodeEditorAppSettings(SpaceCodeEditorAppSettings codeEditorAppSettings) {
        this.setCodeEditorAppSettings(codeEditorAppSettings);
        return this;
    }

    public void setJupyterLabAppSettings(SpaceJupyterLabAppSettings jupyterLabAppSettings) {
        this.jupyterLabAppSettings = jupyterLabAppSettings;
    }

    public SpaceJupyterLabAppSettings getJupyterLabAppSettings() {
        return this.jupyterLabAppSettings;
    }

    public SpaceSettings withJupyterLabAppSettings(SpaceJupyterLabAppSettings jupyterLabAppSettings) {
        this.setJupyterLabAppSettings(jupyterLabAppSettings);
        return this;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public String getAppType() {
        return this.appType;
    }

    public SpaceSettings withAppType(String appType) {
        this.setAppType(appType);
        return this;
    }

    public SpaceSettings withAppType(AppType appType) {
        this.appType = appType.toString();
        return this;
    }

    public void setSpaceStorageSettings(SpaceStorageSettings spaceStorageSettings) {
        this.spaceStorageSettings = spaceStorageSettings;
    }

    public SpaceStorageSettings getSpaceStorageSettings() {
        return this.spaceStorageSettings;
    }

    public SpaceSettings withSpaceStorageSettings(SpaceStorageSettings spaceStorageSettings) {
        this.setSpaceStorageSettings(spaceStorageSettings);
        return this;
    }

    public List<CustomFileSystem> getCustomFileSystems() {
        return this.customFileSystems;
    }

    public void setCustomFileSystems(Collection<CustomFileSystem> customFileSystems) {
        if (customFileSystems == null) {
            this.customFileSystems = null;
            return;
        }
        this.customFileSystems = new ArrayList<CustomFileSystem>(customFileSystems);
    }

    public SpaceSettings withCustomFileSystems(CustomFileSystem ... customFileSystems) {
        if (this.customFileSystems == null) {
            this.setCustomFileSystems(new ArrayList<CustomFileSystem>(customFileSystems.length));
        }
        for (CustomFileSystem ele : customFileSystems) {
            this.customFileSystems.add(ele);
        }
        return this;
    }

    public SpaceSettings withCustomFileSystems(Collection<CustomFileSystem> customFileSystems) {
        this.setCustomFileSystems(customFileSystems);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJupyterServerAppSettings() != null) {
            sb.append("JupyterServerAppSettings: ").append(this.getJupyterServerAppSettings()).append(",");
        }
        if (this.getKernelGatewayAppSettings() != null) {
            sb.append("KernelGatewayAppSettings: ").append(this.getKernelGatewayAppSettings()).append(",");
        }
        if (this.getCodeEditorAppSettings() != null) {
            sb.append("CodeEditorAppSettings: ").append(this.getCodeEditorAppSettings()).append(",");
        }
        if (this.getJupyterLabAppSettings() != null) {
            sb.append("JupyterLabAppSettings: ").append(this.getJupyterLabAppSettings()).append(",");
        }
        if (this.getAppType() != null) {
            sb.append("AppType: ").append(this.getAppType()).append(",");
        }
        if (this.getSpaceStorageSettings() != null) {
            sb.append("SpaceStorageSettings: ").append(this.getSpaceStorageSettings()).append(",");
        }
        if (this.getCustomFileSystems() != null) {
            sb.append("CustomFileSystems: ").append(this.getCustomFileSystems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceSettings)) {
            return false;
        }
        SpaceSettings other = (SpaceSettings)obj;
        if (other.getJupyterServerAppSettings() == null ^ this.getJupyterServerAppSettings() == null) {
            return false;
        }
        if (other.getJupyterServerAppSettings() != null && !other.getJupyterServerAppSettings().equals(this.getJupyterServerAppSettings())) {
            return false;
        }
        if (other.getKernelGatewayAppSettings() == null ^ this.getKernelGatewayAppSettings() == null) {
            return false;
        }
        if (other.getKernelGatewayAppSettings() != null && !other.getKernelGatewayAppSettings().equals(this.getKernelGatewayAppSettings())) {
            return false;
        }
        if (other.getCodeEditorAppSettings() == null ^ this.getCodeEditorAppSettings() == null) {
            return false;
        }
        if (other.getCodeEditorAppSettings() != null && !other.getCodeEditorAppSettings().equals(this.getCodeEditorAppSettings())) {
            return false;
        }
        if (other.getJupyterLabAppSettings() == null ^ this.getJupyterLabAppSettings() == null) {
            return false;
        }
        if (other.getJupyterLabAppSettings() != null && !other.getJupyterLabAppSettings().equals(this.getJupyterLabAppSettings())) {
            return false;
        }
        if (other.getAppType() == null ^ this.getAppType() == null) {
            return false;
        }
        if (other.getAppType() != null && !other.getAppType().equals(this.getAppType())) {
            return false;
        }
        if (other.getSpaceStorageSettings() == null ^ this.getSpaceStorageSettings() == null) {
            return false;
        }
        if (other.getSpaceStorageSettings() != null && !other.getSpaceStorageSettings().equals(this.getSpaceStorageSettings())) {
            return false;
        }
        if (other.getCustomFileSystems() == null ^ this.getCustomFileSystems() == null) {
            return false;
        }
        return other.getCustomFileSystems() == null || other.getCustomFileSystems().equals(this.getCustomFileSystems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJupyterServerAppSettings() == null ? 0 : this.getJupyterServerAppSettings().hashCode());
        hashCode = 31 * hashCode + (this.getKernelGatewayAppSettings() == null ? 0 : this.getKernelGatewayAppSettings().hashCode());
        hashCode = 31 * hashCode + (this.getCodeEditorAppSettings() == null ? 0 : this.getCodeEditorAppSettings().hashCode());
        hashCode = 31 * hashCode + (this.getJupyterLabAppSettings() == null ? 0 : this.getJupyterLabAppSettings().hashCode());
        hashCode = 31 * hashCode + (this.getAppType() == null ? 0 : this.getAppType().hashCode());
        hashCode = 31 * hashCode + (this.getSpaceStorageSettings() == null ? 0 : this.getSpaceStorageSettings().hashCode());
        hashCode = 31 * hashCode + (this.getCustomFileSystems() == null ? 0 : this.getCustomFileSystems().hashCode());
        return hashCode;
    }

    public SpaceSettings clone() {
        try {
            return (SpaceSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SpaceSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

