/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ShadowModelVariantConfig;
import com.amazonaws.services.sagemaker.model.transform.ShadowModeConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ShadowModeConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String sourceModelVariantName;
    private List<ShadowModelVariantConfig> shadowModelVariants;

    public void setSourceModelVariantName(String sourceModelVariantName) {
        this.sourceModelVariantName = sourceModelVariantName;
    }

    public String getSourceModelVariantName() {
        return this.sourceModelVariantName;
    }

    public ShadowModeConfig withSourceModelVariantName(String sourceModelVariantName) {
        this.setSourceModelVariantName(sourceModelVariantName);
        return this;
    }

    public List<ShadowModelVariantConfig> getShadowModelVariants() {
        return this.shadowModelVariants;
    }

    public void setShadowModelVariants(Collection<ShadowModelVariantConfig> shadowModelVariants) {
        if (shadowModelVariants == null) {
            this.shadowModelVariants = null;
            return;
        }
        this.shadowModelVariants = new ArrayList<ShadowModelVariantConfig>(shadowModelVariants);
    }

    public ShadowModeConfig withShadowModelVariants(ShadowModelVariantConfig ... shadowModelVariants) {
        if (this.shadowModelVariants == null) {
            this.setShadowModelVariants(new ArrayList<ShadowModelVariantConfig>(shadowModelVariants.length));
        }
        for (ShadowModelVariantConfig ele : shadowModelVariants) {
            this.shadowModelVariants.add(ele);
        }
        return this;
    }

    public ShadowModeConfig withShadowModelVariants(Collection<ShadowModelVariantConfig> shadowModelVariants) {
        this.setShadowModelVariants(shadowModelVariants);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSourceModelVariantName() != null) {
            sb.append("SourceModelVariantName: ").append(this.getSourceModelVariantName()).append(",");
        }
        if (this.getShadowModelVariants() != null) {
            sb.append("ShadowModelVariants: ").append(this.getShadowModelVariants());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShadowModeConfig)) {
            return false;
        }
        ShadowModeConfig other = (ShadowModeConfig)obj;
        if (other.getSourceModelVariantName() == null ^ this.getSourceModelVariantName() == null) {
            return false;
        }
        if (other.getSourceModelVariantName() != null && !other.getSourceModelVariantName().equals(this.getSourceModelVariantName())) {
            return false;
        }
        if (other.getShadowModelVariants() == null ^ this.getShadowModelVariants() == null) {
            return false;
        }
        return other.getShadowModelVariants() == null || other.getShadowModelVariants().equals(this.getShadowModelVariants());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSourceModelVariantName() == null ? 0 : this.getSourceModelVariantName().hashCode());
        hashCode = 31 * hashCode + (this.getShadowModelVariants() == null ? 0 : this.getShadowModelVariants().hashCode());
        return hashCode;
    }

    public ShadowModeConfig clone() {
        try {
            return (ShadowModeConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ShadowModeConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

