/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.BooleanOperator;
import com.amazonaws.services.sagemaker.model.Filter;
import com.amazonaws.services.sagemaker.model.NestedFilters;
import com.amazonaws.services.sagemaker.model.transform.SearchExpressionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchExpression
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Filter> filters;
    private List<NestedFilters> nestedFilters;
    private List<SearchExpression> subExpressions;
    private String operator;

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<Filter>(filters);
    }

    public SearchExpression withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public SearchExpression withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public List<NestedFilters> getNestedFilters() {
        return this.nestedFilters;
    }

    public void setNestedFilters(Collection<NestedFilters> nestedFilters) {
        if (nestedFilters == null) {
            this.nestedFilters = null;
            return;
        }
        this.nestedFilters = new ArrayList<NestedFilters>(nestedFilters);
    }

    public SearchExpression withNestedFilters(NestedFilters ... nestedFilters) {
        if (this.nestedFilters == null) {
            this.setNestedFilters(new ArrayList<NestedFilters>(nestedFilters.length));
        }
        for (NestedFilters ele : nestedFilters) {
            this.nestedFilters.add(ele);
        }
        return this;
    }

    public SearchExpression withNestedFilters(Collection<NestedFilters> nestedFilters) {
        this.setNestedFilters(nestedFilters);
        return this;
    }

    public List<SearchExpression> getSubExpressions() {
        return this.subExpressions;
    }

    public void setSubExpressions(Collection<SearchExpression> subExpressions) {
        if (subExpressions == null) {
            this.subExpressions = null;
            return;
        }
        this.subExpressions = new ArrayList<SearchExpression>(subExpressions);
    }

    public SearchExpression withSubExpressions(SearchExpression ... subExpressions) {
        if (this.subExpressions == null) {
            this.setSubExpressions(new ArrayList<SearchExpression>(subExpressions.length));
        }
        for (SearchExpression ele : subExpressions) {
            this.subExpressions.add(ele);
        }
        return this;
    }

    public SearchExpression withSubExpressions(Collection<SearchExpression> subExpressions) {
        this.setSubExpressions(subExpressions);
        return this;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOperator() {
        return this.operator;
    }

    public SearchExpression withOperator(String operator) {
        this.setOperator(operator);
        return this;
    }

    public SearchExpression withOperator(BooleanOperator operator) {
        this.operator = operator.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getNestedFilters() != null) {
            sb.append("NestedFilters: ").append(this.getNestedFilters()).append(",");
        }
        if (this.getSubExpressions() != null) {
            sb.append("SubExpressions: ").append(this.getSubExpressions()).append(",");
        }
        if (this.getOperator() != null) {
            sb.append("Operator: ").append(this.getOperator());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchExpression)) {
            return false;
        }
        SearchExpression other = (SearchExpression)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getNestedFilters() == null ^ this.getNestedFilters() == null) {
            return false;
        }
        if (other.getNestedFilters() != null && !other.getNestedFilters().equals(this.getNestedFilters())) {
            return false;
        }
        if (other.getSubExpressions() == null ^ this.getSubExpressions() == null) {
            return false;
        }
        if (other.getSubExpressions() != null && !other.getSubExpressions().equals(this.getSubExpressions())) {
            return false;
        }
        if (other.getOperator() == null ^ this.getOperator() == null) {
            return false;
        }
        return other.getOperator() == null || other.getOperator().equals(this.getOperator());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getNestedFilters() == null ? 0 : this.getNestedFilters().hashCode());
        hashCode = 31 * hashCode + (this.getSubExpressions() == null ? 0 : this.getSubExpressions().hashCode());
        hashCode = 31 * hashCode + (this.getOperator() == null ? 0 : this.getOperator().hashCode());
        return hashCode;
    }

    public SearchExpression clone() {
        try {
            return (SearchExpression)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SearchExpressionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

