/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.InstanceGroup;
import com.amazonaws.services.sagemaker.model.TrainingInstanceType;
import com.amazonaws.services.sagemaker.model.transform.ResourceConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResourceConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String instanceType;
    private Integer instanceCount;
    private Integer volumeSizeInGB;
    private String volumeKmsKeyId;
    private Integer keepAlivePeriodInSeconds;
    private List<InstanceGroup> instanceGroups;

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public ResourceConfig withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public ResourceConfig withInstanceType(TrainingInstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public ResourceConfig withInstanceCount(Integer instanceCount) {
        this.setInstanceCount(instanceCount);
        return this;
    }

    public void setVolumeSizeInGB(Integer volumeSizeInGB) {
        this.volumeSizeInGB = volumeSizeInGB;
    }

    public Integer getVolumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public ResourceConfig withVolumeSizeInGB(Integer volumeSizeInGB) {
        this.setVolumeSizeInGB(volumeSizeInGB);
        return this;
    }

    public void setVolumeKmsKeyId(String volumeKmsKeyId) {
        this.volumeKmsKeyId = volumeKmsKeyId;
    }

    public String getVolumeKmsKeyId() {
        return this.volumeKmsKeyId;
    }

    public ResourceConfig withVolumeKmsKeyId(String volumeKmsKeyId) {
        this.setVolumeKmsKeyId(volumeKmsKeyId);
        return this;
    }

    public void setKeepAlivePeriodInSeconds(Integer keepAlivePeriodInSeconds) {
        this.keepAlivePeriodInSeconds = keepAlivePeriodInSeconds;
    }

    public Integer getKeepAlivePeriodInSeconds() {
        return this.keepAlivePeriodInSeconds;
    }

    public ResourceConfig withKeepAlivePeriodInSeconds(Integer keepAlivePeriodInSeconds) {
        this.setKeepAlivePeriodInSeconds(keepAlivePeriodInSeconds);
        return this;
    }

    public List<InstanceGroup> getInstanceGroups() {
        return this.instanceGroups;
    }

    public void setInstanceGroups(Collection<InstanceGroup> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
            return;
        }
        this.instanceGroups = new ArrayList<InstanceGroup>(instanceGroups);
    }

    public ResourceConfig withInstanceGroups(InstanceGroup ... instanceGroups) {
        if (this.instanceGroups == null) {
            this.setInstanceGroups(new ArrayList<InstanceGroup>(instanceGroups.length));
        }
        for (InstanceGroup ele : instanceGroups) {
            this.instanceGroups.add(ele);
        }
        return this;
    }

    public ResourceConfig withInstanceGroups(Collection<InstanceGroup> instanceGroups) {
        this.setInstanceGroups(instanceGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getInstanceCount() != null) {
            sb.append("InstanceCount: ").append(this.getInstanceCount()).append(",");
        }
        if (this.getVolumeSizeInGB() != null) {
            sb.append("VolumeSizeInGB: ").append(this.getVolumeSizeInGB()).append(",");
        }
        if (this.getVolumeKmsKeyId() != null) {
            sb.append("VolumeKmsKeyId: ").append(this.getVolumeKmsKeyId()).append(",");
        }
        if (this.getKeepAlivePeriodInSeconds() != null) {
            sb.append("KeepAlivePeriodInSeconds: ").append(this.getKeepAlivePeriodInSeconds()).append(",");
        }
        if (this.getInstanceGroups() != null) {
            sb.append("InstanceGroups: ").append(this.getInstanceGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfig)) {
            return false;
        }
        ResourceConfig other = (ResourceConfig)obj;
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getInstanceCount() == null ^ this.getInstanceCount() == null) {
            return false;
        }
        if (other.getInstanceCount() != null && !other.getInstanceCount().equals(this.getInstanceCount())) {
            return false;
        }
        if (other.getVolumeSizeInGB() == null ^ this.getVolumeSizeInGB() == null) {
            return false;
        }
        if (other.getVolumeSizeInGB() != null && !other.getVolumeSizeInGB().equals(this.getVolumeSizeInGB())) {
            return false;
        }
        if (other.getVolumeKmsKeyId() == null ^ this.getVolumeKmsKeyId() == null) {
            return false;
        }
        if (other.getVolumeKmsKeyId() != null && !other.getVolumeKmsKeyId().equals(this.getVolumeKmsKeyId())) {
            return false;
        }
        if (other.getKeepAlivePeriodInSeconds() == null ^ this.getKeepAlivePeriodInSeconds() == null) {
            return false;
        }
        if (other.getKeepAlivePeriodInSeconds() != null && !other.getKeepAlivePeriodInSeconds().equals(this.getKeepAlivePeriodInSeconds())) {
            return false;
        }
        if (other.getInstanceGroups() == null ^ this.getInstanceGroups() == null) {
            return false;
        }
        return other.getInstanceGroups() == null || other.getInstanceGroups().equals(this.getInstanceGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCount() == null ? 0 : this.getInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeSizeInGB() == null ? 0 : this.getVolumeSizeInGB().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeKmsKeyId() == null ? 0 : this.getVolumeKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getKeepAlivePeriodInSeconds() == null ? 0 : this.getKeepAlivePeriodInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceGroups() == null ? 0 : this.getInstanceGroups().hashCode());
        return hashCode;
    }

    public ResourceConfig clone() {
        try {
            return (ResourceConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

