/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.CustomImage;
import com.amazonaws.services.sagemaker.model.ResourceSpec;
import com.amazonaws.services.sagemaker.model.transform.RSessionAppSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RSessionAppSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private ResourceSpec defaultResourceSpec;
    private List<CustomImage> customImages;

    public void setDefaultResourceSpec(ResourceSpec defaultResourceSpec) {
        this.defaultResourceSpec = defaultResourceSpec;
    }

    public ResourceSpec getDefaultResourceSpec() {
        return this.defaultResourceSpec;
    }

    public RSessionAppSettings withDefaultResourceSpec(ResourceSpec defaultResourceSpec) {
        this.setDefaultResourceSpec(defaultResourceSpec);
        return this;
    }

    public List<CustomImage> getCustomImages() {
        return this.customImages;
    }

    public void setCustomImages(Collection<CustomImage> customImages) {
        if (customImages == null) {
            this.customImages = null;
            return;
        }
        this.customImages = new ArrayList<CustomImage>(customImages);
    }

    public RSessionAppSettings withCustomImages(CustomImage ... customImages) {
        if (this.customImages == null) {
            this.setCustomImages(new ArrayList<CustomImage>(customImages.length));
        }
        for (CustomImage ele : customImages) {
            this.customImages.add(ele);
        }
        return this;
    }

    public RSessionAppSettings withCustomImages(Collection<CustomImage> customImages) {
        this.setCustomImages(customImages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefaultResourceSpec() != null) {
            sb.append("DefaultResourceSpec: ").append(this.getDefaultResourceSpec()).append(",");
        }
        if (this.getCustomImages() != null) {
            sb.append("CustomImages: ").append(this.getCustomImages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RSessionAppSettings)) {
            return false;
        }
        RSessionAppSettings other = (RSessionAppSettings)obj;
        if (other.getDefaultResourceSpec() == null ^ this.getDefaultResourceSpec() == null) {
            return false;
        }
        if (other.getDefaultResourceSpec() != null && !other.getDefaultResourceSpec().equals(this.getDefaultResourceSpec())) {
            return false;
        }
        if (other.getCustomImages() == null ^ this.getCustomImages() == null) {
            return false;
        }
        return other.getCustomImages() == null || other.getCustomImages().equals(this.getCustomImages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefaultResourceSpec() == null ? 0 : this.getDefaultResourceSpec().hashCode());
        hashCode = 31 * hashCode + (this.getCustomImages() == null ? 0 : this.getCustomImages().hashCode());
        return hashCode;
    }

    public RSessionAppSettings clone() {
        try {
            return (RSessionAppSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RSessionAppSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

