/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ParallelismConfiguration;
import com.amazonaws.services.sagemaker.model.Parameter;
import com.amazonaws.services.sagemaker.model.PipelineExecutionStatus;
import com.amazonaws.services.sagemaker.model.PipelineExperimentConfig;
import com.amazonaws.services.sagemaker.model.SelectiveExecutionConfig;
import com.amazonaws.services.sagemaker.model.UserContext;
import com.amazonaws.services.sagemaker.model.transform.PipelineExecutionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class PipelineExecution
implements Serializable,
Cloneable,
StructuredPojo {
    private String pipelineArn;
    private String pipelineExecutionArn;
    private String pipelineExecutionDisplayName;
    private String pipelineExecutionStatus;
    private String pipelineExecutionDescription;
    private PipelineExperimentConfig pipelineExperimentConfig;
    private String failureReason;
    private Date creationTime;
    private Date lastModifiedTime;
    private UserContext createdBy;
    private UserContext lastModifiedBy;
    private ParallelismConfiguration parallelismConfiguration;
    private SelectiveExecutionConfig selectiveExecutionConfig;
    private List<Parameter> pipelineParameters;

    public void setPipelineArn(String pipelineArn) {
        this.pipelineArn = pipelineArn;
    }

    public String getPipelineArn() {
        return this.pipelineArn;
    }

    public PipelineExecution withPipelineArn(String pipelineArn) {
        this.setPipelineArn(pipelineArn);
        return this;
    }

    public void setPipelineExecutionArn(String pipelineExecutionArn) {
        this.pipelineExecutionArn = pipelineExecutionArn;
    }

    public String getPipelineExecutionArn() {
        return this.pipelineExecutionArn;
    }

    public PipelineExecution withPipelineExecutionArn(String pipelineExecutionArn) {
        this.setPipelineExecutionArn(pipelineExecutionArn);
        return this;
    }

    public void setPipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
        this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
    }

    public String getPipelineExecutionDisplayName() {
        return this.pipelineExecutionDisplayName;
    }

    public PipelineExecution withPipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
        this.setPipelineExecutionDisplayName(pipelineExecutionDisplayName);
        return this;
    }

    public void setPipelineExecutionStatus(String pipelineExecutionStatus) {
        this.pipelineExecutionStatus = pipelineExecutionStatus;
    }

    public String getPipelineExecutionStatus() {
        return this.pipelineExecutionStatus;
    }

    public PipelineExecution withPipelineExecutionStatus(String pipelineExecutionStatus) {
        this.setPipelineExecutionStatus(pipelineExecutionStatus);
        return this;
    }

    public PipelineExecution withPipelineExecutionStatus(PipelineExecutionStatus pipelineExecutionStatus) {
        this.pipelineExecutionStatus = pipelineExecutionStatus.toString();
        return this;
    }

    public void setPipelineExecutionDescription(String pipelineExecutionDescription) {
        this.pipelineExecutionDescription = pipelineExecutionDescription;
    }

    public String getPipelineExecutionDescription() {
        return this.pipelineExecutionDescription;
    }

    public PipelineExecution withPipelineExecutionDescription(String pipelineExecutionDescription) {
        this.setPipelineExecutionDescription(pipelineExecutionDescription);
        return this;
    }

    public void setPipelineExperimentConfig(PipelineExperimentConfig pipelineExperimentConfig) {
        this.pipelineExperimentConfig = pipelineExperimentConfig;
    }

    public PipelineExperimentConfig getPipelineExperimentConfig() {
        return this.pipelineExperimentConfig;
    }

    public PipelineExecution withPipelineExperimentConfig(PipelineExperimentConfig pipelineExperimentConfig) {
        this.setPipelineExperimentConfig(pipelineExperimentConfig);
        return this;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public PipelineExecution withFailureReason(String failureReason) {
        this.setFailureReason(failureReason);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public PipelineExecution withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public PipelineExecution withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public void setCreatedBy(UserContext createdBy) {
        this.createdBy = createdBy;
    }

    public UserContext getCreatedBy() {
        return this.createdBy;
    }

    public PipelineExecution withCreatedBy(UserContext createdBy) {
        this.setCreatedBy(createdBy);
        return this;
    }

    public void setLastModifiedBy(UserContext lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public UserContext getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public PipelineExecution withLastModifiedBy(UserContext lastModifiedBy) {
        this.setLastModifiedBy(lastModifiedBy);
        return this;
    }

    public void setParallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
        this.parallelismConfiguration = parallelismConfiguration;
    }

    public ParallelismConfiguration getParallelismConfiguration() {
        return this.parallelismConfiguration;
    }

    public PipelineExecution withParallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
        this.setParallelismConfiguration(parallelismConfiguration);
        return this;
    }

    public void setSelectiveExecutionConfig(SelectiveExecutionConfig selectiveExecutionConfig) {
        this.selectiveExecutionConfig = selectiveExecutionConfig;
    }

    public SelectiveExecutionConfig getSelectiveExecutionConfig() {
        return this.selectiveExecutionConfig;
    }

    public PipelineExecution withSelectiveExecutionConfig(SelectiveExecutionConfig selectiveExecutionConfig) {
        this.setSelectiveExecutionConfig(selectiveExecutionConfig);
        return this;
    }

    public List<Parameter> getPipelineParameters() {
        return this.pipelineParameters;
    }

    public void setPipelineParameters(Collection<Parameter> pipelineParameters) {
        if (pipelineParameters == null) {
            this.pipelineParameters = null;
            return;
        }
        this.pipelineParameters = new ArrayList<Parameter>(pipelineParameters);
    }

    public PipelineExecution withPipelineParameters(Parameter ... pipelineParameters) {
        if (this.pipelineParameters == null) {
            this.setPipelineParameters(new ArrayList<Parameter>(pipelineParameters.length));
        }
        for (Parameter ele : pipelineParameters) {
            this.pipelineParameters.add(ele);
        }
        return this;
    }

    public PipelineExecution withPipelineParameters(Collection<Parameter> pipelineParameters) {
        this.setPipelineParameters(pipelineParameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineArn() != null) {
            sb.append("PipelineArn: ").append(this.getPipelineArn()).append(",");
        }
        if (this.getPipelineExecutionArn() != null) {
            sb.append("PipelineExecutionArn: ").append(this.getPipelineExecutionArn()).append(",");
        }
        if (this.getPipelineExecutionDisplayName() != null) {
            sb.append("PipelineExecutionDisplayName: ").append(this.getPipelineExecutionDisplayName()).append(",");
        }
        if (this.getPipelineExecutionStatus() != null) {
            sb.append("PipelineExecutionStatus: ").append(this.getPipelineExecutionStatus()).append(",");
        }
        if (this.getPipelineExecutionDescription() != null) {
            sb.append("PipelineExecutionDescription: ").append(this.getPipelineExecutionDescription()).append(",");
        }
        if (this.getPipelineExperimentConfig() != null) {
            sb.append("PipelineExperimentConfig: ").append(this.getPipelineExperimentConfig()).append(",");
        }
        if (this.getFailureReason() != null) {
            sb.append("FailureReason: ").append(this.getFailureReason()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getCreatedBy() != null) {
            sb.append("CreatedBy: ").append(this.getCreatedBy()).append(",");
        }
        if (this.getLastModifiedBy() != null) {
            sb.append("LastModifiedBy: ").append(this.getLastModifiedBy()).append(",");
        }
        if (this.getParallelismConfiguration() != null) {
            sb.append("ParallelismConfiguration: ").append(this.getParallelismConfiguration()).append(",");
        }
        if (this.getSelectiveExecutionConfig() != null) {
            sb.append("SelectiveExecutionConfig: ").append(this.getSelectiveExecutionConfig()).append(",");
        }
        if (this.getPipelineParameters() != null) {
            sb.append("PipelineParameters: ").append(this.getPipelineParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineExecution)) {
            return false;
        }
        PipelineExecution other = (PipelineExecution)obj;
        if (other.getPipelineArn() == null ^ this.getPipelineArn() == null) {
            return false;
        }
        if (other.getPipelineArn() != null && !other.getPipelineArn().equals(this.getPipelineArn())) {
            return false;
        }
        if (other.getPipelineExecutionArn() == null ^ this.getPipelineExecutionArn() == null) {
            return false;
        }
        if (other.getPipelineExecutionArn() != null && !other.getPipelineExecutionArn().equals(this.getPipelineExecutionArn())) {
            return false;
        }
        if (other.getPipelineExecutionDisplayName() == null ^ this.getPipelineExecutionDisplayName() == null) {
            return false;
        }
        if (other.getPipelineExecutionDisplayName() != null && !other.getPipelineExecutionDisplayName().equals(this.getPipelineExecutionDisplayName())) {
            return false;
        }
        if (other.getPipelineExecutionStatus() == null ^ this.getPipelineExecutionStatus() == null) {
            return false;
        }
        if (other.getPipelineExecutionStatus() != null && !other.getPipelineExecutionStatus().equals(this.getPipelineExecutionStatus())) {
            return false;
        }
        if (other.getPipelineExecutionDescription() == null ^ this.getPipelineExecutionDescription() == null) {
            return false;
        }
        if (other.getPipelineExecutionDescription() != null && !other.getPipelineExecutionDescription().equals(this.getPipelineExecutionDescription())) {
            return false;
        }
        if (other.getPipelineExperimentConfig() == null ^ this.getPipelineExperimentConfig() == null) {
            return false;
        }
        if (other.getPipelineExperimentConfig() != null && !other.getPipelineExperimentConfig().equals(this.getPipelineExperimentConfig())) {
            return false;
        }
        if (other.getFailureReason() == null ^ this.getFailureReason() == null) {
            return false;
        }
        if (other.getFailureReason() != null && !other.getFailureReason().equals(this.getFailureReason())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getCreatedBy() == null ^ this.getCreatedBy() == null) {
            return false;
        }
        if (other.getCreatedBy() != null && !other.getCreatedBy().equals(this.getCreatedBy())) {
            return false;
        }
        if (other.getLastModifiedBy() == null ^ this.getLastModifiedBy() == null) {
            return false;
        }
        if (other.getLastModifiedBy() != null && !other.getLastModifiedBy().equals(this.getLastModifiedBy())) {
            return false;
        }
        if (other.getParallelismConfiguration() == null ^ this.getParallelismConfiguration() == null) {
            return false;
        }
        if (other.getParallelismConfiguration() != null && !other.getParallelismConfiguration().equals(this.getParallelismConfiguration())) {
            return false;
        }
        if (other.getSelectiveExecutionConfig() == null ^ this.getSelectiveExecutionConfig() == null) {
            return false;
        }
        if (other.getSelectiveExecutionConfig() != null && !other.getSelectiveExecutionConfig().equals(this.getSelectiveExecutionConfig())) {
            return false;
        }
        if (other.getPipelineParameters() == null ^ this.getPipelineParameters() == null) {
            return false;
        }
        return other.getPipelineParameters() == null || other.getPipelineParameters().equals(this.getPipelineParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineArn() == null ? 0 : this.getPipelineArn().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineExecutionArn() == null ? 0 : this.getPipelineExecutionArn().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineExecutionDisplayName() == null ? 0 : this.getPipelineExecutionDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineExecutionStatus() == null ? 0 : this.getPipelineExecutionStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineExecutionDescription() == null ? 0 : this.getPipelineExecutionDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineExperimentConfig() == null ? 0 : this.getPipelineExperimentConfig().hashCode());
        hashCode = 31 * hashCode + (this.getFailureReason() == null ? 0 : this.getFailureReason().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        hashCode = 31 * hashCode + (this.getParallelismConfiguration() == null ? 0 : this.getParallelismConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getSelectiveExecutionConfig() == null ? 0 : this.getSelectiveExecutionConfig().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineParameters() == null ? 0 : this.getPipelineParameters().hashCode());
        return hashCode;
    }

    public PipelineExecution clone() {
        try {
            return (PipelineExecution)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PipelineExecutionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

