/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.OutputCompressionType;
import com.amazonaws.services.sagemaker.model.transform.OutputDataConfigMarshaller;
import java.io.Serializable;

public class OutputDataConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String kmsKeyId;
    private String s3OutputPath;
    private String compressionType;

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public OutputDataConfig withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setS3OutputPath(String s3OutputPath) {
        this.s3OutputPath = s3OutputPath;
    }

    public String getS3OutputPath() {
        return this.s3OutputPath;
    }

    public OutputDataConfig withS3OutputPath(String s3OutputPath) {
        this.setS3OutputPath(s3OutputPath);
        return this;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public OutputDataConfig withCompressionType(String compressionType) {
        this.setCompressionType(compressionType);
        return this;
    }

    public OutputDataConfig withCompressionType(OutputCompressionType compressionType) {
        this.compressionType = compressionType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getS3OutputPath() != null) {
            sb.append("S3OutputPath: ").append(this.getS3OutputPath()).append(",");
        }
        if (this.getCompressionType() != null) {
            sb.append("CompressionType: ").append(this.getCompressionType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDataConfig)) {
            return false;
        }
        OutputDataConfig other = (OutputDataConfig)obj;
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getS3OutputPath() == null ^ this.getS3OutputPath() == null) {
            return false;
        }
        if (other.getS3OutputPath() != null && !other.getS3OutputPath().equals(this.getS3OutputPath())) {
            return false;
        }
        if (other.getCompressionType() == null ^ this.getCompressionType() == null) {
            return false;
        }
        return other.getCompressionType() == null || other.getCompressionType().equals(this.getCompressionType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getS3OutputPath() == null ? 0 : this.getS3OutputPath().hashCode());
        hashCode = 31 * hashCode + (this.getCompressionType() == null ? 0 : this.getCompressionType().hashCode());
        return hashCode;
    }

    public OutputDataConfig clone() {
        try {
            return (OutputDataConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputDataConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

