/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.TargetDevice;
import com.amazonaws.services.sagemaker.model.TargetPlatform;
import com.amazonaws.services.sagemaker.model.transform.OutputConfigMarshaller;
import java.io.Serializable;

public class OutputConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3OutputLocation;
    private String targetDevice;
    private TargetPlatform targetPlatform;
    private String compilerOptions;
    private String kmsKeyId;

    public void setS3OutputLocation(String s3OutputLocation) {
        this.s3OutputLocation = s3OutputLocation;
    }

    public String getS3OutputLocation() {
        return this.s3OutputLocation;
    }

    public OutputConfig withS3OutputLocation(String s3OutputLocation) {
        this.setS3OutputLocation(s3OutputLocation);
        return this;
    }

    public void setTargetDevice(String targetDevice) {
        this.targetDevice = targetDevice;
    }

    public String getTargetDevice() {
        return this.targetDevice;
    }

    public OutputConfig withTargetDevice(String targetDevice) {
        this.setTargetDevice(targetDevice);
        return this;
    }

    public OutputConfig withTargetDevice(TargetDevice targetDevice) {
        this.targetDevice = targetDevice.toString();
        return this;
    }

    public void setTargetPlatform(TargetPlatform targetPlatform) {
        this.targetPlatform = targetPlatform;
    }

    public TargetPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    public OutputConfig withTargetPlatform(TargetPlatform targetPlatform) {
        this.setTargetPlatform(targetPlatform);
        return this;
    }

    public void setCompilerOptions(String compilerOptions) {
        this.compilerOptions = compilerOptions;
    }

    public String getCompilerOptions() {
        return this.compilerOptions;
    }

    public OutputConfig withCompilerOptions(String compilerOptions) {
        this.setCompilerOptions(compilerOptions);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public OutputConfig withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3OutputLocation() != null) {
            sb.append("S3OutputLocation: ").append(this.getS3OutputLocation()).append(",");
        }
        if (this.getTargetDevice() != null) {
            sb.append("TargetDevice: ").append(this.getTargetDevice()).append(",");
        }
        if (this.getTargetPlatform() != null) {
            sb.append("TargetPlatform: ").append(this.getTargetPlatform()).append(",");
        }
        if (this.getCompilerOptions() != null) {
            sb.append("CompilerOptions: ").append(this.getCompilerOptions()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputConfig)) {
            return false;
        }
        OutputConfig other = (OutputConfig)obj;
        if (other.getS3OutputLocation() == null ^ this.getS3OutputLocation() == null) {
            return false;
        }
        if (other.getS3OutputLocation() != null && !other.getS3OutputLocation().equals(this.getS3OutputLocation())) {
            return false;
        }
        if (other.getTargetDevice() == null ^ this.getTargetDevice() == null) {
            return false;
        }
        if (other.getTargetDevice() != null && !other.getTargetDevice().equals(this.getTargetDevice())) {
            return false;
        }
        if (other.getTargetPlatform() == null ^ this.getTargetPlatform() == null) {
            return false;
        }
        if (other.getTargetPlatform() != null && !other.getTargetPlatform().equals(this.getTargetPlatform())) {
            return false;
        }
        if (other.getCompilerOptions() == null ^ this.getCompilerOptions() == null) {
            return false;
        }
        if (other.getCompilerOptions() != null && !other.getCompilerOptions().equals(this.getCompilerOptions())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        return other.getKmsKeyId() == null || other.getKmsKeyId().equals(this.getKmsKeyId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3OutputLocation() == null ? 0 : this.getS3OutputLocation().hashCode());
        hashCode = 31 * hashCode + (this.getTargetDevice() == null ? 0 : this.getTargetDevice().hashCode());
        hashCode = 31 * hashCode + (this.getTargetPlatform() == null ? 0 : this.getTargetPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getCompilerOptions() == null ? 0 : this.getCompilerOptions().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        return hashCode;
    }

    public OutputConfig clone() {
        try {
            return (OutputConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

