/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.AutoMLMetricEnum;
import com.amazonaws.services.sagemaker.model.AutoMLMetricExtendedEnum;
import com.amazonaws.services.sagemaker.model.MetricSetSource;
import com.amazonaws.services.sagemaker.model.transform.MetricDatumMarshaller;
import java.io.Serializable;

public class MetricDatum
implements Serializable,
Cloneable,
StructuredPojo {
    private String metricName;
    private Float value;
    private String set;
    private String standardMetricName;

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public MetricDatum withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public MetricDatum withMetricName(AutoMLMetricEnum metricName) {
        this.metricName = metricName.toString();
        return this;
    }

    public void setValue(Float value) {
        this.value = value;
    }

    public Float getValue() {
        return this.value;
    }

    public MetricDatum withValue(Float value) {
        this.setValue(value);
        return this;
    }

    public void setSet(String set) {
        this.set = set;
    }

    public String getSet() {
        return this.set;
    }

    public MetricDatum withSet(String set) {
        this.setSet(set);
        return this;
    }

    public MetricDatum withSet(MetricSetSource set) {
        this.set = set.toString();
        return this;
    }

    public void setStandardMetricName(String standardMetricName) {
        this.standardMetricName = standardMetricName;
    }

    public String getStandardMetricName() {
        return this.standardMetricName;
    }

    public MetricDatum withStandardMetricName(String standardMetricName) {
        this.setStandardMetricName(standardMetricName);
        return this;
    }

    public MetricDatum withStandardMetricName(AutoMLMetricExtendedEnum standardMetricName) {
        this.standardMetricName = standardMetricName.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getSet() != null) {
            sb.append("Set: ").append(this.getSet()).append(",");
        }
        if (this.getStandardMetricName() != null) {
            sb.append("StandardMetricName: ").append(this.getStandardMetricName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDatum)) {
            return false;
        }
        MetricDatum other = (MetricDatum)obj;
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getSet() == null ^ this.getSet() == null) {
            return false;
        }
        if (other.getSet() != null && !other.getSet().equals(this.getSet())) {
            return false;
        }
        if (other.getStandardMetricName() == null ^ this.getStandardMetricName() == null) {
            return false;
        }
        return other.getStandardMetricName() == null || other.getStandardMetricName().equals(this.getStandardMetricName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getSet() == null ? 0 : this.getSet().hashCode());
        hashCode = 31 * hashCode + (this.getStandardMetricName() == null ? 0 : this.getStandardMetricName().hashCode());
        return hashCode;
    }

    public MetricDatum clone() {
        try {
            return (MetricDatum)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricDatumMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

