/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ModelPackageContainerDefinition;
import com.amazonaws.services.sagemaker.model.ProductionVariantInstanceType;
import com.amazonaws.services.sagemaker.model.TransformInstanceType;
import com.amazonaws.services.sagemaker.model.transform.InferenceSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class InferenceSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ModelPackageContainerDefinition> containers;
    private List<String> supportedTransformInstanceTypes;
    private List<String> supportedRealtimeInferenceInstanceTypes;
    private List<String> supportedContentTypes;
    private List<String> supportedResponseMIMETypes;

    public List<ModelPackageContainerDefinition> getContainers() {
        return this.containers;
    }

    public void setContainers(Collection<ModelPackageContainerDefinition> containers) {
        if (containers == null) {
            this.containers = null;
            return;
        }
        this.containers = new ArrayList<ModelPackageContainerDefinition>(containers);
    }

    public InferenceSpecification withContainers(ModelPackageContainerDefinition ... containers) {
        if (this.containers == null) {
            this.setContainers(new ArrayList<ModelPackageContainerDefinition>(containers.length));
        }
        for (ModelPackageContainerDefinition ele : containers) {
            this.containers.add(ele);
        }
        return this;
    }

    public InferenceSpecification withContainers(Collection<ModelPackageContainerDefinition> containers) {
        this.setContainers(containers);
        return this;
    }

    public List<String> getSupportedTransformInstanceTypes() {
        return this.supportedTransformInstanceTypes;
    }

    public void setSupportedTransformInstanceTypes(Collection<String> supportedTransformInstanceTypes) {
        if (supportedTransformInstanceTypes == null) {
            this.supportedTransformInstanceTypes = null;
            return;
        }
        this.supportedTransformInstanceTypes = new ArrayList<String>(supportedTransformInstanceTypes);
    }

    public InferenceSpecification withSupportedTransformInstanceTypes(String ... supportedTransformInstanceTypes) {
        if (this.supportedTransformInstanceTypes == null) {
            this.setSupportedTransformInstanceTypes(new ArrayList<String>(supportedTransformInstanceTypes.length));
        }
        for (String ele : supportedTransformInstanceTypes) {
            this.supportedTransformInstanceTypes.add(ele);
        }
        return this;
    }

    public InferenceSpecification withSupportedTransformInstanceTypes(Collection<String> supportedTransformInstanceTypes) {
        this.setSupportedTransformInstanceTypes(supportedTransformInstanceTypes);
        return this;
    }

    public InferenceSpecification withSupportedTransformInstanceTypes(TransformInstanceType ... supportedTransformInstanceTypes) {
        ArrayList<String> supportedTransformInstanceTypesCopy = new ArrayList<String>(supportedTransformInstanceTypes.length);
        for (TransformInstanceType value : supportedTransformInstanceTypes) {
            supportedTransformInstanceTypesCopy.add(value.toString());
        }
        if (this.getSupportedTransformInstanceTypes() == null) {
            this.setSupportedTransformInstanceTypes(supportedTransformInstanceTypesCopy);
        } else {
            this.getSupportedTransformInstanceTypes().addAll(supportedTransformInstanceTypesCopy);
        }
        return this;
    }

    public List<String> getSupportedRealtimeInferenceInstanceTypes() {
        return this.supportedRealtimeInferenceInstanceTypes;
    }

    public void setSupportedRealtimeInferenceInstanceTypes(Collection<String> supportedRealtimeInferenceInstanceTypes) {
        if (supportedRealtimeInferenceInstanceTypes == null) {
            this.supportedRealtimeInferenceInstanceTypes = null;
            return;
        }
        this.supportedRealtimeInferenceInstanceTypes = new ArrayList<String>(supportedRealtimeInferenceInstanceTypes);
    }

    public InferenceSpecification withSupportedRealtimeInferenceInstanceTypes(String ... supportedRealtimeInferenceInstanceTypes) {
        if (this.supportedRealtimeInferenceInstanceTypes == null) {
            this.setSupportedRealtimeInferenceInstanceTypes(new ArrayList<String>(supportedRealtimeInferenceInstanceTypes.length));
        }
        for (String ele : supportedRealtimeInferenceInstanceTypes) {
            this.supportedRealtimeInferenceInstanceTypes.add(ele);
        }
        return this;
    }

    public InferenceSpecification withSupportedRealtimeInferenceInstanceTypes(Collection<String> supportedRealtimeInferenceInstanceTypes) {
        this.setSupportedRealtimeInferenceInstanceTypes(supportedRealtimeInferenceInstanceTypes);
        return this;
    }

    public InferenceSpecification withSupportedRealtimeInferenceInstanceTypes(ProductionVariantInstanceType ... supportedRealtimeInferenceInstanceTypes) {
        ArrayList<String> supportedRealtimeInferenceInstanceTypesCopy = new ArrayList<String>(supportedRealtimeInferenceInstanceTypes.length);
        for (ProductionVariantInstanceType value : supportedRealtimeInferenceInstanceTypes) {
            supportedRealtimeInferenceInstanceTypesCopy.add(value.toString());
        }
        if (this.getSupportedRealtimeInferenceInstanceTypes() == null) {
            this.setSupportedRealtimeInferenceInstanceTypes(supportedRealtimeInferenceInstanceTypesCopy);
        } else {
            this.getSupportedRealtimeInferenceInstanceTypes().addAll(supportedRealtimeInferenceInstanceTypesCopy);
        }
        return this;
    }

    public List<String> getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    public void setSupportedContentTypes(Collection<String> supportedContentTypes) {
        if (supportedContentTypes == null) {
            this.supportedContentTypes = null;
            return;
        }
        this.supportedContentTypes = new ArrayList<String>(supportedContentTypes);
    }

    public InferenceSpecification withSupportedContentTypes(String ... supportedContentTypes) {
        if (this.supportedContentTypes == null) {
            this.setSupportedContentTypes(new ArrayList<String>(supportedContentTypes.length));
        }
        for (String ele : supportedContentTypes) {
            this.supportedContentTypes.add(ele);
        }
        return this;
    }

    public InferenceSpecification withSupportedContentTypes(Collection<String> supportedContentTypes) {
        this.setSupportedContentTypes(supportedContentTypes);
        return this;
    }

    public List<String> getSupportedResponseMIMETypes() {
        return this.supportedResponseMIMETypes;
    }

    public void setSupportedResponseMIMETypes(Collection<String> supportedResponseMIMETypes) {
        if (supportedResponseMIMETypes == null) {
            this.supportedResponseMIMETypes = null;
            return;
        }
        this.supportedResponseMIMETypes = new ArrayList<String>(supportedResponseMIMETypes);
    }

    public InferenceSpecification withSupportedResponseMIMETypes(String ... supportedResponseMIMETypes) {
        if (this.supportedResponseMIMETypes == null) {
            this.setSupportedResponseMIMETypes(new ArrayList<String>(supportedResponseMIMETypes.length));
        }
        for (String ele : supportedResponseMIMETypes) {
            this.supportedResponseMIMETypes.add(ele);
        }
        return this;
    }

    public InferenceSpecification withSupportedResponseMIMETypes(Collection<String> supportedResponseMIMETypes) {
        this.setSupportedResponseMIMETypes(supportedResponseMIMETypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainers() != null) {
            sb.append("Containers: ").append(this.getContainers()).append(",");
        }
        if (this.getSupportedTransformInstanceTypes() != null) {
            sb.append("SupportedTransformInstanceTypes: ").append(this.getSupportedTransformInstanceTypes()).append(",");
        }
        if (this.getSupportedRealtimeInferenceInstanceTypes() != null) {
            sb.append("SupportedRealtimeInferenceInstanceTypes: ").append(this.getSupportedRealtimeInferenceInstanceTypes()).append(",");
        }
        if (this.getSupportedContentTypes() != null) {
            sb.append("SupportedContentTypes: ").append(this.getSupportedContentTypes()).append(",");
        }
        if (this.getSupportedResponseMIMETypes() != null) {
            sb.append("SupportedResponseMIMETypes: ").append(this.getSupportedResponseMIMETypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceSpecification)) {
            return false;
        }
        InferenceSpecification other = (InferenceSpecification)obj;
        if (other.getContainers() == null ^ this.getContainers() == null) {
            return false;
        }
        if (other.getContainers() != null && !other.getContainers().equals(this.getContainers())) {
            return false;
        }
        if (other.getSupportedTransformInstanceTypes() == null ^ this.getSupportedTransformInstanceTypes() == null) {
            return false;
        }
        if (other.getSupportedTransformInstanceTypes() != null && !other.getSupportedTransformInstanceTypes().equals(this.getSupportedTransformInstanceTypes())) {
            return false;
        }
        if (other.getSupportedRealtimeInferenceInstanceTypes() == null ^ this.getSupportedRealtimeInferenceInstanceTypes() == null) {
            return false;
        }
        if (other.getSupportedRealtimeInferenceInstanceTypes() != null && !other.getSupportedRealtimeInferenceInstanceTypes().equals(this.getSupportedRealtimeInferenceInstanceTypes())) {
            return false;
        }
        if (other.getSupportedContentTypes() == null ^ this.getSupportedContentTypes() == null) {
            return false;
        }
        if (other.getSupportedContentTypes() != null && !other.getSupportedContentTypes().equals(this.getSupportedContentTypes())) {
            return false;
        }
        if (other.getSupportedResponseMIMETypes() == null ^ this.getSupportedResponseMIMETypes() == null) {
            return false;
        }
        return other.getSupportedResponseMIMETypes() == null || other.getSupportedResponseMIMETypes().equals(this.getSupportedResponseMIMETypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainers() == null ? 0 : this.getContainers().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedTransformInstanceTypes() == null ? 0 : this.getSupportedTransformInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedRealtimeInferenceInstanceTypes() == null ? 0 : this.getSupportedRealtimeInferenceInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedContentTypes() == null ? 0 : this.getSupportedContentTypes().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedResponseMIMETypes() == null ? 0 : this.getSupportedResponseMIMETypes().hashCode());
        return hashCode;
    }

    public InferenceSpecification clone() {
        try {
            return (InferenceSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InferenceSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

