/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.HyperParameterTuningAllocationStrategy;
import com.amazonaws.services.sagemaker.model.HyperParameterTuningInstanceConfig;
import com.amazonaws.services.sagemaker.model.TrainingInstanceType;
import com.amazonaws.services.sagemaker.model.transform.HyperParameterTuningResourceConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HyperParameterTuningResourceConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String instanceType;
    private Integer instanceCount;
    private Integer volumeSizeInGB;
    private String volumeKmsKeyId;
    private String allocationStrategy;
    private List<HyperParameterTuningInstanceConfig> instanceConfigs;

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public HyperParameterTuningResourceConfig withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public HyperParameterTuningResourceConfig withInstanceType(TrainingInstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public HyperParameterTuningResourceConfig withInstanceCount(Integer instanceCount) {
        this.setInstanceCount(instanceCount);
        return this;
    }

    public void setVolumeSizeInGB(Integer volumeSizeInGB) {
        this.volumeSizeInGB = volumeSizeInGB;
    }

    public Integer getVolumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public HyperParameterTuningResourceConfig withVolumeSizeInGB(Integer volumeSizeInGB) {
        this.setVolumeSizeInGB(volumeSizeInGB);
        return this;
    }

    public void setVolumeKmsKeyId(String volumeKmsKeyId) {
        this.volumeKmsKeyId = volumeKmsKeyId;
    }

    public String getVolumeKmsKeyId() {
        return this.volumeKmsKeyId;
    }

    public HyperParameterTuningResourceConfig withVolumeKmsKeyId(String volumeKmsKeyId) {
        this.setVolumeKmsKeyId(volumeKmsKeyId);
        return this;
    }

    public void setAllocationStrategy(String allocationStrategy) {
        this.allocationStrategy = allocationStrategy;
    }

    public String getAllocationStrategy() {
        return this.allocationStrategy;
    }

    public HyperParameterTuningResourceConfig withAllocationStrategy(String allocationStrategy) {
        this.setAllocationStrategy(allocationStrategy);
        return this;
    }

    public HyperParameterTuningResourceConfig withAllocationStrategy(HyperParameterTuningAllocationStrategy allocationStrategy) {
        this.allocationStrategy = allocationStrategy.toString();
        return this;
    }

    public List<HyperParameterTuningInstanceConfig> getInstanceConfigs() {
        return this.instanceConfigs;
    }

    public void setInstanceConfigs(Collection<HyperParameterTuningInstanceConfig> instanceConfigs) {
        if (instanceConfigs == null) {
            this.instanceConfigs = null;
            return;
        }
        this.instanceConfigs = new ArrayList<HyperParameterTuningInstanceConfig>(instanceConfigs);
    }

    public HyperParameterTuningResourceConfig withInstanceConfigs(HyperParameterTuningInstanceConfig ... instanceConfigs) {
        if (this.instanceConfigs == null) {
            this.setInstanceConfigs(new ArrayList<HyperParameterTuningInstanceConfig>(instanceConfigs.length));
        }
        for (HyperParameterTuningInstanceConfig ele : instanceConfigs) {
            this.instanceConfigs.add(ele);
        }
        return this;
    }

    public HyperParameterTuningResourceConfig withInstanceConfigs(Collection<HyperParameterTuningInstanceConfig> instanceConfigs) {
        this.setInstanceConfigs(instanceConfigs);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getInstanceCount() != null) {
            sb.append("InstanceCount: ").append(this.getInstanceCount()).append(",");
        }
        if (this.getVolumeSizeInGB() != null) {
            sb.append("VolumeSizeInGB: ").append(this.getVolumeSizeInGB()).append(",");
        }
        if (this.getVolumeKmsKeyId() != null) {
            sb.append("VolumeKmsKeyId: ").append(this.getVolumeKmsKeyId()).append(",");
        }
        if (this.getAllocationStrategy() != null) {
            sb.append("AllocationStrategy: ").append(this.getAllocationStrategy()).append(",");
        }
        if (this.getInstanceConfigs() != null) {
            sb.append("InstanceConfigs: ").append(this.getInstanceConfigs());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTuningResourceConfig)) {
            return false;
        }
        HyperParameterTuningResourceConfig other = (HyperParameterTuningResourceConfig)obj;
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getInstanceCount() == null ^ this.getInstanceCount() == null) {
            return false;
        }
        if (other.getInstanceCount() != null && !other.getInstanceCount().equals(this.getInstanceCount())) {
            return false;
        }
        if (other.getVolumeSizeInGB() == null ^ this.getVolumeSizeInGB() == null) {
            return false;
        }
        if (other.getVolumeSizeInGB() != null && !other.getVolumeSizeInGB().equals(this.getVolumeSizeInGB())) {
            return false;
        }
        if (other.getVolumeKmsKeyId() == null ^ this.getVolumeKmsKeyId() == null) {
            return false;
        }
        if (other.getVolumeKmsKeyId() != null && !other.getVolumeKmsKeyId().equals(this.getVolumeKmsKeyId())) {
            return false;
        }
        if (other.getAllocationStrategy() == null ^ this.getAllocationStrategy() == null) {
            return false;
        }
        if (other.getAllocationStrategy() != null && !other.getAllocationStrategy().equals(this.getAllocationStrategy())) {
            return false;
        }
        if (other.getInstanceConfigs() == null ^ this.getInstanceConfigs() == null) {
            return false;
        }
        return other.getInstanceConfigs() == null || other.getInstanceConfigs().equals(this.getInstanceConfigs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCount() == null ? 0 : this.getInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeSizeInGB() == null ? 0 : this.getVolumeSizeInGB().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeKmsKeyId() == null ? 0 : this.getVolumeKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getAllocationStrategy() == null ? 0 : this.getAllocationStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceConfigs() == null ? 0 : this.getInstanceConfigs().hashCode());
        return hashCode;
    }

    public HyperParameterTuningResourceConfig clone() {
        try {
            return (HyperParameterTuningResourceConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HyperParameterTuningResourceConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

