/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.Channel;
import com.amazonaws.services.sagemaker.model.CheckpointConfig;
import com.amazonaws.services.sagemaker.model.HyperParameterAlgorithmSpecification;
import com.amazonaws.services.sagemaker.model.HyperParameterTuningJobObjective;
import com.amazonaws.services.sagemaker.model.HyperParameterTuningResourceConfig;
import com.amazonaws.services.sagemaker.model.OutputDataConfig;
import com.amazonaws.services.sagemaker.model.ParameterRanges;
import com.amazonaws.services.sagemaker.model.ResourceConfig;
import com.amazonaws.services.sagemaker.model.RetryStrategy;
import com.amazonaws.services.sagemaker.model.StoppingCondition;
import com.amazonaws.services.sagemaker.model.VpcConfig;
import com.amazonaws.services.sagemaker.model.transform.HyperParameterTrainingJobDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HyperParameterTrainingJobDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String definitionName;
    private HyperParameterTuningJobObjective tuningObjective;
    private ParameterRanges hyperParameterRanges;
    private Map<String, String> staticHyperParameters;
    private HyperParameterAlgorithmSpecification algorithmSpecification;
    private String roleArn;
    private List<Channel> inputDataConfig;
    private VpcConfig vpcConfig;
    private OutputDataConfig outputDataConfig;
    private ResourceConfig resourceConfig;
    private HyperParameterTuningResourceConfig hyperParameterTuningResourceConfig;
    private StoppingCondition stoppingCondition;
    private Boolean enableNetworkIsolation;
    private Boolean enableInterContainerTrafficEncryption;
    private Boolean enableManagedSpotTraining;
    private CheckpointConfig checkpointConfig;
    private RetryStrategy retryStrategy;
    private Map<String, String> environment;

    public void setDefinitionName(String definitionName) {
        this.definitionName = definitionName;
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public HyperParameterTrainingJobDefinition withDefinitionName(String definitionName) {
        this.setDefinitionName(definitionName);
        return this;
    }

    public void setTuningObjective(HyperParameterTuningJobObjective tuningObjective) {
        this.tuningObjective = tuningObjective;
    }

    public HyperParameterTuningJobObjective getTuningObjective() {
        return this.tuningObjective;
    }

    public HyperParameterTrainingJobDefinition withTuningObjective(HyperParameterTuningJobObjective tuningObjective) {
        this.setTuningObjective(tuningObjective);
        return this;
    }

    public void setHyperParameterRanges(ParameterRanges hyperParameterRanges) {
        this.hyperParameterRanges = hyperParameterRanges;
    }

    public ParameterRanges getHyperParameterRanges() {
        return this.hyperParameterRanges;
    }

    public HyperParameterTrainingJobDefinition withHyperParameterRanges(ParameterRanges hyperParameterRanges) {
        this.setHyperParameterRanges(hyperParameterRanges);
        return this;
    }

    public Map<String, String> getStaticHyperParameters() {
        return this.staticHyperParameters;
    }

    public void setStaticHyperParameters(Map<String, String> staticHyperParameters) {
        this.staticHyperParameters = staticHyperParameters;
    }

    public HyperParameterTrainingJobDefinition withStaticHyperParameters(Map<String, String> staticHyperParameters) {
        this.setStaticHyperParameters(staticHyperParameters);
        return this;
    }

    public HyperParameterTrainingJobDefinition addStaticHyperParametersEntry(String key, String value) {
        if (null == this.staticHyperParameters) {
            this.staticHyperParameters = new HashMap<String, String>();
        }
        if (this.staticHyperParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.staticHyperParameters.put(key, value);
        return this;
    }

    public HyperParameterTrainingJobDefinition clearStaticHyperParametersEntries() {
        this.staticHyperParameters = null;
        return this;
    }

    public void setAlgorithmSpecification(HyperParameterAlgorithmSpecification algorithmSpecification) {
        this.algorithmSpecification = algorithmSpecification;
    }

    public HyperParameterAlgorithmSpecification getAlgorithmSpecification() {
        return this.algorithmSpecification;
    }

    public HyperParameterTrainingJobDefinition withAlgorithmSpecification(HyperParameterAlgorithmSpecification algorithmSpecification) {
        this.setAlgorithmSpecification(algorithmSpecification);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public HyperParameterTrainingJobDefinition withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public List<Channel> getInputDataConfig() {
        return this.inputDataConfig;
    }

    public void setInputDataConfig(Collection<Channel> inputDataConfig) {
        if (inputDataConfig == null) {
            this.inputDataConfig = null;
            return;
        }
        this.inputDataConfig = new ArrayList<Channel>(inputDataConfig);
    }

    public HyperParameterTrainingJobDefinition withInputDataConfig(Channel ... inputDataConfig) {
        if (this.inputDataConfig == null) {
            this.setInputDataConfig(new ArrayList<Channel>(inputDataConfig.length));
        }
        for (Channel ele : inputDataConfig) {
            this.inputDataConfig.add(ele);
        }
        return this;
    }

    public HyperParameterTrainingJobDefinition withInputDataConfig(Collection<Channel> inputDataConfig) {
        this.setInputDataConfig(inputDataConfig);
        return this;
    }

    public void setVpcConfig(VpcConfig vpcConfig) {
        this.vpcConfig = vpcConfig;
    }

    public VpcConfig getVpcConfig() {
        return this.vpcConfig;
    }

    public HyperParameterTrainingJobDefinition withVpcConfig(VpcConfig vpcConfig) {
        this.setVpcConfig(vpcConfig);
        return this;
    }

    public void setOutputDataConfig(OutputDataConfig outputDataConfig) {
        this.outputDataConfig = outputDataConfig;
    }

    public OutputDataConfig getOutputDataConfig() {
        return this.outputDataConfig;
    }

    public HyperParameterTrainingJobDefinition withOutputDataConfig(OutputDataConfig outputDataConfig) {
        this.setOutputDataConfig(outputDataConfig);
        return this;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    public ResourceConfig getResourceConfig() {
        return this.resourceConfig;
    }

    public HyperParameterTrainingJobDefinition withResourceConfig(ResourceConfig resourceConfig) {
        this.setResourceConfig(resourceConfig);
        return this;
    }

    public void setHyperParameterTuningResourceConfig(HyperParameterTuningResourceConfig hyperParameterTuningResourceConfig) {
        this.hyperParameterTuningResourceConfig = hyperParameterTuningResourceConfig;
    }

    public HyperParameterTuningResourceConfig getHyperParameterTuningResourceConfig() {
        return this.hyperParameterTuningResourceConfig;
    }

    public HyperParameterTrainingJobDefinition withHyperParameterTuningResourceConfig(HyperParameterTuningResourceConfig hyperParameterTuningResourceConfig) {
        this.setHyperParameterTuningResourceConfig(hyperParameterTuningResourceConfig);
        return this;
    }

    public void setStoppingCondition(StoppingCondition stoppingCondition) {
        this.stoppingCondition = stoppingCondition;
    }

    public StoppingCondition getStoppingCondition() {
        return this.stoppingCondition;
    }

    public HyperParameterTrainingJobDefinition withStoppingCondition(StoppingCondition stoppingCondition) {
        this.setStoppingCondition(stoppingCondition);
        return this;
    }

    public void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
        this.enableNetworkIsolation = enableNetworkIsolation;
    }

    public Boolean getEnableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public HyperParameterTrainingJobDefinition withEnableNetworkIsolation(Boolean enableNetworkIsolation) {
        this.setEnableNetworkIsolation(enableNetworkIsolation);
        return this;
    }

    public Boolean isEnableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
        this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
    }

    public Boolean getEnableInterContainerTrafficEncryption() {
        return this.enableInterContainerTrafficEncryption;
    }

    public HyperParameterTrainingJobDefinition withEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
        this.setEnableInterContainerTrafficEncryption(enableInterContainerTrafficEncryption);
        return this;
    }

    public Boolean isEnableInterContainerTrafficEncryption() {
        return this.enableInterContainerTrafficEncryption;
    }

    public void setEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
        this.enableManagedSpotTraining = enableManagedSpotTraining;
    }

    public Boolean getEnableManagedSpotTraining() {
        return this.enableManagedSpotTraining;
    }

    public HyperParameterTrainingJobDefinition withEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
        this.setEnableManagedSpotTraining(enableManagedSpotTraining);
        return this;
    }

    public Boolean isEnableManagedSpotTraining() {
        return this.enableManagedSpotTraining;
    }

    public void setCheckpointConfig(CheckpointConfig checkpointConfig) {
        this.checkpointConfig = checkpointConfig;
    }

    public CheckpointConfig getCheckpointConfig() {
        return this.checkpointConfig;
    }

    public HyperParameterTrainingJobDefinition withCheckpointConfig(CheckpointConfig checkpointConfig) {
        this.setCheckpointConfig(checkpointConfig);
        return this;
    }

    public void setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public HyperParameterTrainingJobDefinition withRetryStrategy(RetryStrategy retryStrategy) {
        this.setRetryStrategy(retryStrategy);
        return this;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public HyperParameterTrainingJobDefinition withEnvironment(Map<String, String> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public HyperParameterTrainingJobDefinition addEnvironmentEntry(String key, String value) {
        if (null == this.environment) {
            this.environment = new HashMap<String, String>();
        }
        if (this.environment.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environment.put(key, value);
        return this;
    }

    public HyperParameterTrainingJobDefinition clearEnvironmentEntries() {
        this.environment = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefinitionName() != null) {
            sb.append("DefinitionName: ").append(this.getDefinitionName()).append(",");
        }
        if (this.getTuningObjective() != null) {
            sb.append("TuningObjective: ").append(this.getTuningObjective()).append(",");
        }
        if (this.getHyperParameterRanges() != null) {
            sb.append("HyperParameterRanges: ").append(this.getHyperParameterRanges()).append(",");
        }
        if (this.getStaticHyperParameters() != null) {
            sb.append("StaticHyperParameters: ").append(this.getStaticHyperParameters()).append(",");
        }
        if (this.getAlgorithmSpecification() != null) {
            sb.append("AlgorithmSpecification: ").append(this.getAlgorithmSpecification()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getInputDataConfig() != null) {
            sb.append("InputDataConfig: ").append(this.getInputDataConfig()).append(",");
        }
        if (this.getVpcConfig() != null) {
            sb.append("VpcConfig: ").append(this.getVpcConfig()).append(",");
        }
        if (this.getOutputDataConfig() != null) {
            sb.append("OutputDataConfig: ").append(this.getOutputDataConfig()).append(",");
        }
        if (this.getResourceConfig() != null) {
            sb.append("ResourceConfig: ").append(this.getResourceConfig()).append(",");
        }
        if (this.getHyperParameterTuningResourceConfig() != null) {
            sb.append("HyperParameterTuningResourceConfig: ").append(this.getHyperParameterTuningResourceConfig()).append(",");
        }
        if (this.getStoppingCondition() != null) {
            sb.append("StoppingCondition: ").append(this.getStoppingCondition()).append(",");
        }
        if (this.getEnableNetworkIsolation() != null) {
            sb.append("EnableNetworkIsolation: ").append(this.getEnableNetworkIsolation()).append(",");
        }
        if (this.getEnableInterContainerTrafficEncryption() != null) {
            sb.append("EnableInterContainerTrafficEncryption: ").append(this.getEnableInterContainerTrafficEncryption()).append(",");
        }
        if (this.getEnableManagedSpotTraining() != null) {
            sb.append("EnableManagedSpotTraining: ").append(this.getEnableManagedSpotTraining()).append(",");
        }
        if (this.getCheckpointConfig() != null) {
            sb.append("CheckpointConfig: ").append(this.getCheckpointConfig()).append(",");
        }
        if (this.getRetryStrategy() != null) {
            sb.append("RetryStrategy: ").append(this.getRetryStrategy()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTrainingJobDefinition)) {
            return false;
        }
        HyperParameterTrainingJobDefinition other = (HyperParameterTrainingJobDefinition)obj;
        if (other.getDefinitionName() == null ^ this.getDefinitionName() == null) {
            return false;
        }
        if (other.getDefinitionName() != null && !other.getDefinitionName().equals(this.getDefinitionName())) {
            return false;
        }
        if (other.getTuningObjective() == null ^ this.getTuningObjective() == null) {
            return false;
        }
        if (other.getTuningObjective() != null && !other.getTuningObjective().equals(this.getTuningObjective())) {
            return false;
        }
        if (other.getHyperParameterRanges() == null ^ this.getHyperParameterRanges() == null) {
            return false;
        }
        if (other.getHyperParameterRanges() != null && !other.getHyperParameterRanges().equals(this.getHyperParameterRanges())) {
            return false;
        }
        if (other.getStaticHyperParameters() == null ^ this.getStaticHyperParameters() == null) {
            return false;
        }
        if (other.getStaticHyperParameters() != null && !other.getStaticHyperParameters().equals(this.getStaticHyperParameters())) {
            return false;
        }
        if (other.getAlgorithmSpecification() == null ^ this.getAlgorithmSpecification() == null) {
            return false;
        }
        if (other.getAlgorithmSpecification() != null && !other.getAlgorithmSpecification().equals(this.getAlgorithmSpecification())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getInputDataConfig() == null ^ this.getInputDataConfig() == null) {
            return false;
        }
        if (other.getInputDataConfig() != null && !other.getInputDataConfig().equals(this.getInputDataConfig())) {
            return false;
        }
        if (other.getVpcConfig() == null ^ this.getVpcConfig() == null) {
            return false;
        }
        if (other.getVpcConfig() != null && !other.getVpcConfig().equals(this.getVpcConfig())) {
            return false;
        }
        if (other.getOutputDataConfig() == null ^ this.getOutputDataConfig() == null) {
            return false;
        }
        if (other.getOutputDataConfig() != null && !other.getOutputDataConfig().equals(this.getOutputDataConfig())) {
            return false;
        }
        if (other.getResourceConfig() == null ^ this.getResourceConfig() == null) {
            return false;
        }
        if (other.getResourceConfig() != null && !other.getResourceConfig().equals(this.getResourceConfig())) {
            return false;
        }
        if (other.getHyperParameterTuningResourceConfig() == null ^ this.getHyperParameterTuningResourceConfig() == null) {
            return false;
        }
        if (other.getHyperParameterTuningResourceConfig() != null && !other.getHyperParameterTuningResourceConfig().equals(this.getHyperParameterTuningResourceConfig())) {
            return false;
        }
        if (other.getStoppingCondition() == null ^ this.getStoppingCondition() == null) {
            return false;
        }
        if (other.getStoppingCondition() != null && !other.getStoppingCondition().equals(this.getStoppingCondition())) {
            return false;
        }
        if (other.getEnableNetworkIsolation() == null ^ this.getEnableNetworkIsolation() == null) {
            return false;
        }
        if (other.getEnableNetworkIsolation() != null && !other.getEnableNetworkIsolation().equals(this.getEnableNetworkIsolation())) {
            return false;
        }
        if (other.getEnableInterContainerTrafficEncryption() == null ^ this.getEnableInterContainerTrafficEncryption() == null) {
            return false;
        }
        if (other.getEnableInterContainerTrafficEncryption() != null && !other.getEnableInterContainerTrafficEncryption().equals(this.getEnableInterContainerTrafficEncryption())) {
            return false;
        }
        if (other.getEnableManagedSpotTraining() == null ^ this.getEnableManagedSpotTraining() == null) {
            return false;
        }
        if (other.getEnableManagedSpotTraining() != null && !other.getEnableManagedSpotTraining().equals(this.getEnableManagedSpotTraining())) {
            return false;
        }
        if (other.getCheckpointConfig() == null ^ this.getCheckpointConfig() == null) {
            return false;
        }
        if (other.getCheckpointConfig() != null && !other.getCheckpointConfig().equals(this.getCheckpointConfig())) {
            return false;
        }
        if (other.getRetryStrategy() == null ^ this.getRetryStrategy() == null) {
            return false;
        }
        if (other.getRetryStrategy() != null && !other.getRetryStrategy().equals(this.getRetryStrategy())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        return other.getEnvironment() == null || other.getEnvironment().equals(this.getEnvironment());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefinitionName() == null ? 0 : this.getDefinitionName().hashCode());
        hashCode = 31 * hashCode + (this.getTuningObjective() == null ? 0 : this.getTuningObjective().hashCode());
        hashCode = 31 * hashCode + (this.getHyperParameterRanges() == null ? 0 : this.getHyperParameterRanges().hashCode());
        hashCode = 31 * hashCode + (this.getStaticHyperParameters() == null ? 0 : this.getStaticHyperParameters().hashCode());
        hashCode = 31 * hashCode + (this.getAlgorithmSpecification() == null ? 0 : this.getAlgorithmSpecification().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getInputDataConfig() == null ? 0 : this.getInputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getVpcConfig() == null ? 0 : this.getVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getOutputDataConfig() == null ? 0 : this.getOutputDataConfig().hashCode());
        hashCode = 31 * hashCode + (this.getResourceConfig() == null ? 0 : this.getResourceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getHyperParameterTuningResourceConfig() == null ? 0 : this.getHyperParameterTuningResourceConfig().hashCode());
        hashCode = 31 * hashCode + (this.getStoppingCondition() == null ? 0 : this.getStoppingCondition().hashCode());
        hashCode = 31 * hashCode + (this.getEnableNetworkIsolation() == null ? 0 : this.getEnableNetworkIsolation().hashCode());
        hashCode = 31 * hashCode + (this.getEnableInterContainerTrafficEncryption() == null ? 0 : this.getEnableInterContainerTrafficEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getEnableManagedSpotTraining() == null ? 0 : this.getEnableManagedSpotTraining().hashCode());
        hashCode = 31 * hashCode + (this.getCheckpointConfig() == null ? 0 : this.getCheckpointConfig().hashCode());
        hashCode = 31 * hashCode + (this.getRetryStrategy() == null ? 0 : this.getRetryStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        return hashCode;
    }

    public HyperParameterTrainingJobDefinition clone() {
        try {
            return (HyperParameterTrainingJobDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HyperParameterTrainingJobDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

