/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ProductionVariantInstanceType;
import com.amazonaws.services.sagemaker.model.ProductionVariantServerlessConfig;
import com.amazonaws.services.sagemaker.model.transform.EndpointOutputConfigurationMarshaller;
import java.io.Serializable;

public class EndpointOutputConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String endpointName;
    private String variantName;
    private String instanceType;
    private Integer initialInstanceCount;
    private ProductionVariantServerlessConfig serverlessConfig;

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public EndpointOutputConfiguration withEndpointName(String endpointName) {
        this.setEndpointName(endpointName);
        return this;
    }

    public void setVariantName(String variantName) {
        this.variantName = variantName;
    }

    public String getVariantName() {
        return this.variantName;
    }

    public EndpointOutputConfiguration withVariantName(String variantName) {
        this.setVariantName(variantName);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public EndpointOutputConfiguration withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public EndpointOutputConfiguration withInstanceType(ProductionVariantInstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public void setInitialInstanceCount(Integer initialInstanceCount) {
        this.initialInstanceCount = initialInstanceCount;
    }

    public Integer getInitialInstanceCount() {
        return this.initialInstanceCount;
    }

    public EndpointOutputConfiguration withInitialInstanceCount(Integer initialInstanceCount) {
        this.setInitialInstanceCount(initialInstanceCount);
        return this;
    }

    public void setServerlessConfig(ProductionVariantServerlessConfig serverlessConfig) {
        this.serverlessConfig = serverlessConfig;
    }

    public ProductionVariantServerlessConfig getServerlessConfig() {
        return this.serverlessConfig;
    }

    public EndpointOutputConfiguration withServerlessConfig(ProductionVariantServerlessConfig serverlessConfig) {
        this.setServerlessConfig(serverlessConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointName() != null) {
            sb.append("EndpointName: ").append(this.getEndpointName()).append(",");
        }
        if (this.getVariantName() != null) {
            sb.append("VariantName: ").append(this.getVariantName()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getInitialInstanceCount() != null) {
            sb.append("InitialInstanceCount: ").append(this.getInitialInstanceCount()).append(",");
        }
        if (this.getServerlessConfig() != null) {
            sb.append("ServerlessConfig: ").append(this.getServerlessConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointOutputConfiguration)) {
            return false;
        }
        EndpointOutputConfiguration other = (EndpointOutputConfiguration)obj;
        if (other.getEndpointName() == null ^ this.getEndpointName() == null) {
            return false;
        }
        if (other.getEndpointName() != null && !other.getEndpointName().equals(this.getEndpointName())) {
            return false;
        }
        if (other.getVariantName() == null ^ this.getVariantName() == null) {
            return false;
        }
        if (other.getVariantName() != null && !other.getVariantName().equals(this.getVariantName())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getInitialInstanceCount() == null ^ this.getInitialInstanceCount() == null) {
            return false;
        }
        if (other.getInitialInstanceCount() != null && !other.getInitialInstanceCount().equals(this.getInitialInstanceCount())) {
            return false;
        }
        if (other.getServerlessConfig() == null ^ this.getServerlessConfig() == null) {
            return false;
        }
        return other.getServerlessConfig() == null || other.getServerlessConfig().equals(this.getServerlessConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointName() == null ? 0 : this.getEndpointName().hashCode());
        hashCode = 31 * hashCode + (this.getVariantName() == null ? 0 : this.getVariantName().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getInitialInstanceCount() == null ? 0 : this.getInitialInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getServerlessConfig() == null ? 0 : this.getServerlessConfig().hashCode());
        return hashCode;
    }

    public EndpointOutputConfiguration clone() {
        try {
            return (EndpointOutputConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointOutputConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

