/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.DockerSettings;
import com.amazonaws.services.sagemaker.model.ExecutionRoleIdentityConfig;
import com.amazonaws.services.sagemaker.model.RStudioServerProDomainSettings;
import com.amazonaws.services.sagemaker.model.transform.DomainSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DomainSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> securityGroupIds;
    private RStudioServerProDomainSettings rStudioServerProDomainSettings;
    private String executionRoleIdentityConfig;
    private DockerSettings dockerSettings;

    public List<String> getSecurityGroupIds() {
        return this.securityGroupIds;
    }

    public void setSecurityGroupIds(Collection<String> securityGroupIds) {
        if (securityGroupIds == null) {
            this.securityGroupIds = null;
            return;
        }
        this.securityGroupIds = new ArrayList<String>(securityGroupIds);
    }

    public DomainSettings withSecurityGroupIds(String ... securityGroupIds) {
        if (this.securityGroupIds == null) {
            this.setSecurityGroupIds(new ArrayList<String>(securityGroupIds.length));
        }
        for (String ele : securityGroupIds) {
            this.securityGroupIds.add(ele);
        }
        return this;
    }

    public DomainSettings withSecurityGroupIds(Collection<String> securityGroupIds) {
        this.setSecurityGroupIds(securityGroupIds);
        return this;
    }

    public void setRStudioServerProDomainSettings(RStudioServerProDomainSettings rStudioServerProDomainSettings) {
        this.rStudioServerProDomainSettings = rStudioServerProDomainSettings;
    }

    public RStudioServerProDomainSettings getRStudioServerProDomainSettings() {
        return this.rStudioServerProDomainSettings;
    }

    public DomainSettings withRStudioServerProDomainSettings(RStudioServerProDomainSettings rStudioServerProDomainSettings) {
        this.setRStudioServerProDomainSettings(rStudioServerProDomainSettings);
        return this;
    }

    public void setExecutionRoleIdentityConfig(String executionRoleIdentityConfig) {
        this.executionRoleIdentityConfig = executionRoleIdentityConfig;
    }

    public String getExecutionRoleIdentityConfig() {
        return this.executionRoleIdentityConfig;
    }

    public DomainSettings withExecutionRoleIdentityConfig(String executionRoleIdentityConfig) {
        this.setExecutionRoleIdentityConfig(executionRoleIdentityConfig);
        return this;
    }

    public DomainSettings withExecutionRoleIdentityConfig(ExecutionRoleIdentityConfig executionRoleIdentityConfig) {
        this.executionRoleIdentityConfig = executionRoleIdentityConfig.toString();
        return this;
    }

    public void setDockerSettings(DockerSettings dockerSettings) {
        this.dockerSettings = dockerSettings;
    }

    public DockerSettings getDockerSettings() {
        return this.dockerSettings;
    }

    public DomainSettings withDockerSettings(DockerSettings dockerSettings) {
        this.setDockerSettings(dockerSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.getSecurityGroupIds()).append(",");
        }
        if (this.getRStudioServerProDomainSettings() != null) {
            sb.append("RStudioServerProDomainSettings: ").append(this.getRStudioServerProDomainSettings()).append(",");
        }
        if (this.getExecutionRoleIdentityConfig() != null) {
            sb.append("ExecutionRoleIdentityConfig: ").append(this.getExecutionRoleIdentityConfig()).append(",");
        }
        if (this.getDockerSettings() != null) {
            sb.append("DockerSettings: ").append(this.getDockerSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSettings)) {
            return false;
        }
        DomainSettings other = (DomainSettings)obj;
        if (other.getSecurityGroupIds() == null ^ this.getSecurityGroupIds() == null) {
            return false;
        }
        if (other.getSecurityGroupIds() != null && !other.getSecurityGroupIds().equals(this.getSecurityGroupIds())) {
            return false;
        }
        if (other.getRStudioServerProDomainSettings() == null ^ this.getRStudioServerProDomainSettings() == null) {
            return false;
        }
        if (other.getRStudioServerProDomainSettings() != null && !other.getRStudioServerProDomainSettings().equals(this.getRStudioServerProDomainSettings())) {
            return false;
        }
        if (other.getExecutionRoleIdentityConfig() == null ^ this.getExecutionRoleIdentityConfig() == null) {
            return false;
        }
        if (other.getExecutionRoleIdentityConfig() != null && !other.getExecutionRoleIdentityConfig().equals(this.getExecutionRoleIdentityConfig())) {
            return false;
        }
        if (other.getDockerSettings() == null ^ this.getDockerSettings() == null) {
            return false;
        }
        return other.getDockerSettings() == null || other.getDockerSettings().equals(this.getDockerSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityGroupIds() == null ? 0 : this.getSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.getRStudioServerProDomainSettings() == null ? 0 : this.getRStudioServerProDomainSettings().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionRoleIdentityConfig() == null ? 0 : this.getExecutionRoleIdentityConfig().hashCode());
        hashCode = 31 * hashCode + (this.getDockerSettings() == null ? 0 : this.getDockerSettings().hashCode());
        return hashCode;
    }

    public DomainSettings clone() {
        try {
            return (DomainSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

