/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.FeatureStatus;
import com.amazonaws.services.sagemaker.model.transform.DockerSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DockerSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private String enableDockerAccess;
    private List<String> vpcOnlyTrustedAccounts;

    public void setEnableDockerAccess(String enableDockerAccess) {
        this.enableDockerAccess = enableDockerAccess;
    }

    public String getEnableDockerAccess() {
        return this.enableDockerAccess;
    }

    public DockerSettings withEnableDockerAccess(String enableDockerAccess) {
        this.setEnableDockerAccess(enableDockerAccess);
        return this;
    }

    public DockerSettings withEnableDockerAccess(FeatureStatus enableDockerAccess) {
        this.enableDockerAccess = enableDockerAccess.toString();
        return this;
    }

    public List<String> getVpcOnlyTrustedAccounts() {
        return this.vpcOnlyTrustedAccounts;
    }

    public void setVpcOnlyTrustedAccounts(Collection<String> vpcOnlyTrustedAccounts) {
        if (vpcOnlyTrustedAccounts == null) {
            this.vpcOnlyTrustedAccounts = null;
            return;
        }
        this.vpcOnlyTrustedAccounts = new ArrayList<String>(vpcOnlyTrustedAccounts);
    }

    public DockerSettings withVpcOnlyTrustedAccounts(String ... vpcOnlyTrustedAccounts) {
        if (this.vpcOnlyTrustedAccounts == null) {
            this.setVpcOnlyTrustedAccounts(new ArrayList<String>(vpcOnlyTrustedAccounts.length));
        }
        for (String ele : vpcOnlyTrustedAccounts) {
            this.vpcOnlyTrustedAccounts.add(ele);
        }
        return this;
    }

    public DockerSettings withVpcOnlyTrustedAccounts(Collection<String> vpcOnlyTrustedAccounts) {
        this.setVpcOnlyTrustedAccounts(vpcOnlyTrustedAccounts);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnableDockerAccess() != null) {
            sb.append("EnableDockerAccess: ").append(this.getEnableDockerAccess()).append(",");
        }
        if (this.getVpcOnlyTrustedAccounts() != null) {
            sb.append("VpcOnlyTrustedAccounts: ").append(this.getVpcOnlyTrustedAccounts());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DockerSettings)) {
            return false;
        }
        DockerSettings other = (DockerSettings)obj;
        if (other.getEnableDockerAccess() == null ^ this.getEnableDockerAccess() == null) {
            return false;
        }
        if (other.getEnableDockerAccess() != null && !other.getEnableDockerAccess().equals(this.getEnableDockerAccess())) {
            return false;
        }
        if (other.getVpcOnlyTrustedAccounts() == null ^ this.getVpcOnlyTrustedAccounts() == null) {
            return false;
        }
        return other.getVpcOnlyTrustedAccounts() == null || other.getVpcOnlyTrustedAccounts().equals(this.getVpcOnlyTrustedAccounts());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnableDockerAccess() == null ? 0 : this.getEnableDockerAccess().hashCode());
        hashCode = 31 * hashCode + (this.getVpcOnlyTrustedAccounts() == null ? 0 : this.getVpcOnlyTrustedAccounts().hashCode());
        return hashCode;
    }

    public DockerSettings clone() {
        try {
            return (DockerSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DockerSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

