/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.DeviceSubsetType;
import com.amazonaws.services.sagemaker.model.transform.DeviceSelectionConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeviceSelectionConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String deviceSubsetType;
    private Integer percentage;
    private List<String> deviceNames;
    private String deviceNameContains;

    public void setDeviceSubsetType(String deviceSubsetType) {
        this.deviceSubsetType = deviceSubsetType;
    }

    public String getDeviceSubsetType() {
        return this.deviceSubsetType;
    }

    public DeviceSelectionConfig withDeviceSubsetType(String deviceSubsetType) {
        this.setDeviceSubsetType(deviceSubsetType);
        return this;
    }

    public DeviceSelectionConfig withDeviceSubsetType(DeviceSubsetType deviceSubsetType) {
        this.deviceSubsetType = deviceSubsetType.toString();
        return this;
    }

    public void setPercentage(Integer percentage) {
        this.percentage = percentage;
    }

    public Integer getPercentage() {
        return this.percentage;
    }

    public DeviceSelectionConfig withPercentage(Integer percentage) {
        this.setPercentage(percentage);
        return this;
    }

    public List<String> getDeviceNames() {
        return this.deviceNames;
    }

    public void setDeviceNames(Collection<String> deviceNames) {
        if (deviceNames == null) {
            this.deviceNames = null;
            return;
        }
        this.deviceNames = new ArrayList<String>(deviceNames);
    }

    public DeviceSelectionConfig withDeviceNames(String ... deviceNames) {
        if (this.deviceNames == null) {
            this.setDeviceNames(new ArrayList<String>(deviceNames.length));
        }
        for (String ele : deviceNames) {
            this.deviceNames.add(ele);
        }
        return this;
    }

    public DeviceSelectionConfig withDeviceNames(Collection<String> deviceNames) {
        this.setDeviceNames(deviceNames);
        return this;
    }

    public void setDeviceNameContains(String deviceNameContains) {
        this.deviceNameContains = deviceNameContains;
    }

    public String getDeviceNameContains() {
        return this.deviceNameContains;
    }

    public DeviceSelectionConfig withDeviceNameContains(String deviceNameContains) {
        this.setDeviceNameContains(deviceNameContains);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeviceSubsetType() != null) {
            sb.append("DeviceSubsetType: ").append(this.getDeviceSubsetType()).append(",");
        }
        if (this.getPercentage() != null) {
            sb.append("Percentage: ").append(this.getPercentage()).append(",");
        }
        if (this.getDeviceNames() != null) {
            sb.append("DeviceNames: ").append(this.getDeviceNames()).append(",");
        }
        if (this.getDeviceNameContains() != null) {
            sb.append("DeviceNameContains: ").append(this.getDeviceNameContains());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSelectionConfig)) {
            return false;
        }
        DeviceSelectionConfig other = (DeviceSelectionConfig)obj;
        if (other.getDeviceSubsetType() == null ^ this.getDeviceSubsetType() == null) {
            return false;
        }
        if (other.getDeviceSubsetType() != null && !other.getDeviceSubsetType().equals(this.getDeviceSubsetType())) {
            return false;
        }
        if (other.getPercentage() == null ^ this.getPercentage() == null) {
            return false;
        }
        if (other.getPercentage() != null && !other.getPercentage().equals(this.getPercentage())) {
            return false;
        }
        if (other.getDeviceNames() == null ^ this.getDeviceNames() == null) {
            return false;
        }
        if (other.getDeviceNames() != null && !other.getDeviceNames().equals(this.getDeviceNames())) {
            return false;
        }
        if (other.getDeviceNameContains() == null ^ this.getDeviceNameContains() == null) {
            return false;
        }
        return other.getDeviceNameContains() == null || other.getDeviceNameContains().equals(this.getDeviceNameContains());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeviceSubsetType() == null ? 0 : this.getDeviceSubsetType().hashCode());
        hashCode = 31 * hashCode + (this.getPercentage() == null ? 0 : this.getPercentage().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceNames() == null ? 0 : this.getDeviceNames().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceNameContains() == null ? 0 : this.getDeviceNameContains().hashCode());
        return hashCode;
    }

    public DeviceSelectionConfig clone() {
        try {
            return (DeviceSelectionConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeviceSelectionConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

