/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.transform.DataQualityAppSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataQualityAppSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String imageUri;
    private List<String> containerEntrypoint;
    private List<String> containerArguments;
    private String recordPreprocessorSourceUri;
    private String postAnalyticsProcessorSourceUri;
    private Map<String, String> environment;

    public void setImageUri(String imageUri) {
        this.imageUri = imageUri;
    }

    public String getImageUri() {
        return this.imageUri;
    }

    public DataQualityAppSpecification withImageUri(String imageUri) {
        this.setImageUri(imageUri);
        return this;
    }

    public List<String> getContainerEntrypoint() {
        return this.containerEntrypoint;
    }

    public void setContainerEntrypoint(Collection<String> containerEntrypoint) {
        if (containerEntrypoint == null) {
            this.containerEntrypoint = null;
            return;
        }
        this.containerEntrypoint = new ArrayList<String>(containerEntrypoint);
    }

    public DataQualityAppSpecification withContainerEntrypoint(String ... containerEntrypoint) {
        if (this.containerEntrypoint == null) {
            this.setContainerEntrypoint(new ArrayList<String>(containerEntrypoint.length));
        }
        for (String ele : containerEntrypoint) {
            this.containerEntrypoint.add(ele);
        }
        return this;
    }

    public DataQualityAppSpecification withContainerEntrypoint(Collection<String> containerEntrypoint) {
        this.setContainerEntrypoint(containerEntrypoint);
        return this;
    }

    public List<String> getContainerArguments() {
        return this.containerArguments;
    }

    public void setContainerArguments(Collection<String> containerArguments) {
        if (containerArguments == null) {
            this.containerArguments = null;
            return;
        }
        this.containerArguments = new ArrayList<String>(containerArguments);
    }

    public DataQualityAppSpecification withContainerArguments(String ... containerArguments) {
        if (this.containerArguments == null) {
            this.setContainerArguments(new ArrayList<String>(containerArguments.length));
        }
        for (String ele : containerArguments) {
            this.containerArguments.add(ele);
        }
        return this;
    }

    public DataQualityAppSpecification withContainerArguments(Collection<String> containerArguments) {
        this.setContainerArguments(containerArguments);
        return this;
    }

    public void setRecordPreprocessorSourceUri(String recordPreprocessorSourceUri) {
        this.recordPreprocessorSourceUri = recordPreprocessorSourceUri;
    }

    public String getRecordPreprocessorSourceUri() {
        return this.recordPreprocessorSourceUri;
    }

    public DataQualityAppSpecification withRecordPreprocessorSourceUri(String recordPreprocessorSourceUri) {
        this.setRecordPreprocessorSourceUri(recordPreprocessorSourceUri);
        return this;
    }

    public void setPostAnalyticsProcessorSourceUri(String postAnalyticsProcessorSourceUri) {
        this.postAnalyticsProcessorSourceUri = postAnalyticsProcessorSourceUri;
    }

    public String getPostAnalyticsProcessorSourceUri() {
        return this.postAnalyticsProcessorSourceUri;
    }

    public DataQualityAppSpecification withPostAnalyticsProcessorSourceUri(String postAnalyticsProcessorSourceUri) {
        this.setPostAnalyticsProcessorSourceUri(postAnalyticsProcessorSourceUri);
        return this;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public DataQualityAppSpecification withEnvironment(Map<String, String> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public DataQualityAppSpecification addEnvironmentEntry(String key, String value) {
        if (null == this.environment) {
            this.environment = new HashMap<String, String>();
        }
        if (this.environment.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environment.put(key, value);
        return this;
    }

    public DataQualityAppSpecification clearEnvironmentEntries() {
        this.environment = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageUri() != null) {
            sb.append("ImageUri: ").append(this.getImageUri()).append(",");
        }
        if (this.getContainerEntrypoint() != null) {
            sb.append("ContainerEntrypoint: ").append(this.getContainerEntrypoint()).append(",");
        }
        if (this.getContainerArguments() != null) {
            sb.append("ContainerArguments: ").append(this.getContainerArguments()).append(",");
        }
        if (this.getRecordPreprocessorSourceUri() != null) {
            sb.append("RecordPreprocessorSourceUri: ").append(this.getRecordPreprocessorSourceUri()).append(",");
        }
        if (this.getPostAnalyticsProcessorSourceUri() != null) {
            sb.append("PostAnalyticsProcessorSourceUri: ").append(this.getPostAnalyticsProcessorSourceUri()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityAppSpecification)) {
            return false;
        }
        DataQualityAppSpecification other = (DataQualityAppSpecification)obj;
        if (other.getImageUri() == null ^ this.getImageUri() == null) {
            return false;
        }
        if (other.getImageUri() != null && !other.getImageUri().equals(this.getImageUri())) {
            return false;
        }
        if (other.getContainerEntrypoint() == null ^ this.getContainerEntrypoint() == null) {
            return false;
        }
        if (other.getContainerEntrypoint() != null && !other.getContainerEntrypoint().equals(this.getContainerEntrypoint())) {
            return false;
        }
        if (other.getContainerArguments() == null ^ this.getContainerArguments() == null) {
            return false;
        }
        if (other.getContainerArguments() != null && !other.getContainerArguments().equals(this.getContainerArguments())) {
            return false;
        }
        if (other.getRecordPreprocessorSourceUri() == null ^ this.getRecordPreprocessorSourceUri() == null) {
            return false;
        }
        if (other.getRecordPreprocessorSourceUri() != null && !other.getRecordPreprocessorSourceUri().equals(this.getRecordPreprocessorSourceUri())) {
            return false;
        }
        if (other.getPostAnalyticsProcessorSourceUri() == null ^ this.getPostAnalyticsProcessorSourceUri() == null) {
            return false;
        }
        if (other.getPostAnalyticsProcessorSourceUri() != null && !other.getPostAnalyticsProcessorSourceUri().equals(this.getPostAnalyticsProcessorSourceUri())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        return other.getEnvironment() == null || other.getEnvironment().equals(this.getEnvironment());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageUri() == null ? 0 : this.getImageUri().hashCode());
        hashCode = 31 * hashCode + (this.getContainerEntrypoint() == null ? 0 : this.getContainerEntrypoint().hashCode());
        hashCode = 31 * hashCode + (this.getContainerArguments() == null ? 0 : this.getContainerArguments().hashCode());
        hashCode = 31 * hashCode + (this.getRecordPreprocessorSourceUri() == null ? 0 : this.getRecordPreprocessorSourceUri().hashCode());
        hashCode = 31 * hashCode + (this.getPostAnalyticsProcessorSourceUri() == null ? 0 : this.getPostAnalyticsProcessorSourceUri().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        return hashCode;
    }

    public DataQualityAppSpecification clone() {
        try {
            return (DataQualityAppSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataQualityAppSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

