/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.CaptureContentTypeHeader;
import com.amazonaws.services.sagemaker.model.CaptureOption;
import com.amazonaws.services.sagemaker.model.transform.DataCaptureConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DataCaptureConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean enableCapture;
    private Integer initialSamplingPercentage;
    private String destinationS3Uri;
    private String kmsKeyId;
    private List<CaptureOption> captureOptions;
    private CaptureContentTypeHeader captureContentTypeHeader;

    public void setEnableCapture(Boolean enableCapture) {
        this.enableCapture = enableCapture;
    }

    public Boolean getEnableCapture() {
        return this.enableCapture;
    }

    public DataCaptureConfig withEnableCapture(Boolean enableCapture) {
        this.setEnableCapture(enableCapture);
        return this;
    }

    public Boolean isEnableCapture() {
        return this.enableCapture;
    }

    public void setInitialSamplingPercentage(Integer initialSamplingPercentage) {
        this.initialSamplingPercentage = initialSamplingPercentage;
    }

    public Integer getInitialSamplingPercentage() {
        return this.initialSamplingPercentage;
    }

    public DataCaptureConfig withInitialSamplingPercentage(Integer initialSamplingPercentage) {
        this.setInitialSamplingPercentage(initialSamplingPercentage);
        return this;
    }

    public void setDestinationS3Uri(String destinationS3Uri) {
        this.destinationS3Uri = destinationS3Uri;
    }

    public String getDestinationS3Uri() {
        return this.destinationS3Uri;
    }

    public DataCaptureConfig withDestinationS3Uri(String destinationS3Uri) {
        this.setDestinationS3Uri(destinationS3Uri);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public DataCaptureConfig withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public List<CaptureOption> getCaptureOptions() {
        return this.captureOptions;
    }

    public void setCaptureOptions(Collection<CaptureOption> captureOptions) {
        if (captureOptions == null) {
            this.captureOptions = null;
            return;
        }
        this.captureOptions = new ArrayList<CaptureOption>(captureOptions);
    }

    public DataCaptureConfig withCaptureOptions(CaptureOption ... captureOptions) {
        if (this.captureOptions == null) {
            this.setCaptureOptions(new ArrayList<CaptureOption>(captureOptions.length));
        }
        for (CaptureOption ele : captureOptions) {
            this.captureOptions.add(ele);
        }
        return this;
    }

    public DataCaptureConfig withCaptureOptions(Collection<CaptureOption> captureOptions) {
        this.setCaptureOptions(captureOptions);
        return this;
    }

    public void setCaptureContentTypeHeader(CaptureContentTypeHeader captureContentTypeHeader) {
        this.captureContentTypeHeader = captureContentTypeHeader;
    }

    public CaptureContentTypeHeader getCaptureContentTypeHeader() {
        return this.captureContentTypeHeader;
    }

    public DataCaptureConfig withCaptureContentTypeHeader(CaptureContentTypeHeader captureContentTypeHeader) {
        this.setCaptureContentTypeHeader(captureContentTypeHeader);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnableCapture() != null) {
            sb.append("EnableCapture: ").append(this.getEnableCapture()).append(",");
        }
        if (this.getInitialSamplingPercentage() != null) {
            sb.append("InitialSamplingPercentage: ").append(this.getInitialSamplingPercentage()).append(",");
        }
        if (this.getDestinationS3Uri() != null) {
            sb.append("DestinationS3Uri: ").append(this.getDestinationS3Uri()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getCaptureOptions() != null) {
            sb.append("CaptureOptions: ").append(this.getCaptureOptions()).append(",");
        }
        if (this.getCaptureContentTypeHeader() != null) {
            sb.append("CaptureContentTypeHeader: ").append(this.getCaptureContentTypeHeader());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCaptureConfig)) {
            return false;
        }
        DataCaptureConfig other = (DataCaptureConfig)obj;
        if (other.getEnableCapture() == null ^ this.getEnableCapture() == null) {
            return false;
        }
        if (other.getEnableCapture() != null && !other.getEnableCapture().equals(this.getEnableCapture())) {
            return false;
        }
        if (other.getInitialSamplingPercentage() == null ^ this.getInitialSamplingPercentage() == null) {
            return false;
        }
        if (other.getInitialSamplingPercentage() != null && !other.getInitialSamplingPercentage().equals(this.getInitialSamplingPercentage())) {
            return false;
        }
        if (other.getDestinationS3Uri() == null ^ this.getDestinationS3Uri() == null) {
            return false;
        }
        if (other.getDestinationS3Uri() != null && !other.getDestinationS3Uri().equals(this.getDestinationS3Uri())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getCaptureOptions() == null ^ this.getCaptureOptions() == null) {
            return false;
        }
        if (other.getCaptureOptions() != null && !other.getCaptureOptions().equals(this.getCaptureOptions())) {
            return false;
        }
        if (other.getCaptureContentTypeHeader() == null ^ this.getCaptureContentTypeHeader() == null) {
            return false;
        }
        return other.getCaptureContentTypeHeader() == null || other.getCaptureContentTypeHeader().equals(this.getCaptureContentTypeHeader());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnableCapture() == null ? 0 : this.getEnableCapture().hashCode());
        hashCode = 31 * hashCode + (this.getInitialSamplingPercentage() == null ? 0 : this.getInitialSamplingPercentage().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationS3Uri() == null ? 0 : this.getDestinationS3Uri().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getCaptureOptions() == null ? 0 : this.getCaptureOptions().hashCode());
        hashCode = 31 * hashCode + (this.getCaptureContentTypeHeader() == null ? 0 : this.getCaptureContentTypeHeader().hashCode());
        return hashCode;
    }

    public DataCaptureConfig clone() {
        try {
            return (DataCaptureConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataCaptureConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

