/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.InferenceExperimentDataStorageConfig;
import com.amazonaws.services.sagemaker.model.InferenceExperimentSchedule;
import com.amazonaws.services.sagemaker.model.InferenceExperimentType;
import com.amazonaws.services.sagemaker.model.ModelVariantConfig;
import com.amazonaws.services.sagemaker.model.ShadowModeConfig;
import com.amazonaws.services.sagemaker.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateInferenceExperimentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String type;
    private InferenceExperimentSchedule schedule;
    private String description;
    private String roleArn;
    private String endpointName;
    private List<ModelVariantConfig> modelVariants;
    private InferenceExperimentDataStorageConfig dataStorageConfig;
    private ShadowModeConfig shadowModeConfig;
    private String kmsKey;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateInferenceExperimentRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateInferenceExperimentRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateInferenceExperimentRequest withType(InferenceExperimentType type) {
        this.type = type.toString();
        return this;
    }

    public void setSchedule(InferenceExperimentSchedule schedule) {
        this.schedule = schedule;
    }

    public InferenceExperimentSchedule getSchedule() {
        return this.schedule;
    }

    public CreateInferenceExperimentRequest withSchedule(InferenceExperimentSchedule schedule) {
        this.setSchedule(schedule);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateInferenceExperimentRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateInferenceExperimentRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public CreateInferenceExperimentRequest withEndpointName(String endpointName) {
        this.setEndpointName(endpointName);
        return this;
    }

    public List<ModelVariantConfig> getModelVariants() {
        return this.modelVariants;
    }

    public void setModelVariants(Collection<ModelVariantConfig> modelVariants) {
        if (modelVariants == null) {
            this.modelVariants = null;
            return;
        }
        this.modelVariants = new ArrayList<ModelVariantConfig>(modelVariants);
    }

    public CreateInferenceExperimentRequest withModelVariants(ModelVariantConfig ... modelVariants) {
        if (this.modelVariants == null) {
            this.setModelVariants(new ArrayList<ModelVariantConfig>(modelVariants.length));
        }
        for (ModelVariantConfig ele : modelVariants) {
            this.modelVariants.add(ele);
        }
        return this;
    }

    public CreateInferenceExperimentRequest withModelVariants(Collection<ModelVariantConfig> modelVariants) {
        this.setModelVariants(modelVariants);
        return this;
    }

    public void setDataStorageConfig(InferenceExperimentDataStorageConfig dataStorageConfig) {
        this.dataStorageConfig = dataStorageConfig;
    }

    public InferenceExperimentDataStorageConfig getDataStorageConfig() {
        return this.dataStorageConfig;
    }

    public CreateInferenceExperimentRequest withDataStorageConfig(InferenceExperimentDataStorageConfig dataStorageConfig) {
        this.setDataStorageConfig(dataStorageConfig);
        return this;
    }

    public void setShadowModeConfig(ShadowModeConfig shadowModeConfig) {
        this.shadowModeConfig = shadowModeConfig;
    }

    public ShadowModeConfig getShadowModeConfig() {
        return this.shadowModeConfig;
    }

    public CreateInferenceExperimentRequest withShadowModeConfig(ShadowModeConfig shadowModeConfig) {
        this.setShadowModeConfig(shadowModeConfig);
        return this;
    }

    public void setKmsKey(String kmsKey) {
        this.kmsKey = kmsKey;
    }

    public String getKmsKey() {
        return this.kmsKey;
    }

    public CreateInferenceExperimentRequest withKmsKey(String kmsKey) {
        this.setKmsKey(kmsKey);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateInferenceExperimentRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateInferenceExperimentRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getSchedule() != null) {
            sb.append("Schedule: ").append(this.getSchedule()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getEndpointName() != null) {
            sb.append("EndpointName: ").append(this.getEndpointName()).append(",");
        }
        if (this.getModelVariants() != null) {
            sb.append("ModelVariants: ").append(this.getModelVariants()).append(",");
        }
        if (this.getDataStorageConfig() != null) {
            sb.append("DataStorageConfig: ").append(this.getDataStorageConfig()).append(",");
        }
        if (this.getShadowModeConfig() != null) {
            sb.append("ShadowModeConfig: ").append(this.getShadowModeConfig()).append(",");
        }
        if (this.getKmsKey() != null) {
            sb.append("KmsKey: ").append(this.getKmsKey()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInferenceExperimentRequest)) {
            return false;
        }
        CreateInferenceExperimentRequest other = (CreateInferenceExperimentRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getSchedule() == null ^ this.getSchedule() == null) {
            return false;
        }
        if (other.getSchedule() != null && !other.getSchedule().equals(this.getSchedule())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getEndpointName() == null ^ this.getEndpointName() == null) {
            return false;
        }
        if (other.getEndpointName() != null && !other.getEndpointName().equals(this.getEndpointName())) {
            return false;
        }
        if (other.getModelVariants() == null ^ this.getModelVariants() == null) {
            return false;
        }
        if (other.getModelVariants() != null && !other.getModelVariants().equals(this.getModelVariants())) {
            return false;
        }
        if (other.getDataStorageConfig() == null ^ this.getDataStorageConfig() == null) {
            return false;
        }
        if (other.getDataStorageConfig() != null && !other.getDataStorageConfig().equals(this.getDataStorageConfig())) {
            return false;
        }
        if (other.getShadowModeConfig() == null ^ this.getShadowModeConfig() == null) {
            return false;
        }
        if (other.getShadowModeConfig() != null && !other.getShadowModeConfig().equals(this.getShadowModeConfig())) {
            return false;
        }
        if (other.getKmsKey() == null ^ this.getKmsKey() == null) {
            return false;
        }
        if (other.getKmsKey() != null && !other.getKmsKey().equals(this.getKmsKey())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getSchedule() == null ? 0 : this.getSchedule().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointName() == null ? 0 : this.getEndpointName().hashCode());
        hashCode = 31 * hashCode + (this.getModelVariants() == null ? 0 : this.getModelVariants().hashCode());
        hashCode = 31 * hashCode + (this.getDataStorageConfig() == null ? 0 : this.getDataStorageConfig().hashCode());
        hashCode = 31 * hashCode + (this.getShadowModeConfig() == null ? 0 : this.getShadowModeConfig().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKey() == null ? 0 : this.getKmsKey().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateInferenceExperimentRequest clone() {
        return (CreateInferenceExperimentRequest)super.clone();
    }
}

