/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.ArtifactSource;
import com.amazonaws.services.sagemaker.model.MetadataProperties;
import com.amazonaws.services.sagemaker.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateArtifactRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String artifactName;
    private ArtifactSource source;
    private String artifactType;
    private Map<String, String> properties;
    private MetadataProperties metadataProperties;
    private List<Tag> tags;

    public void setArtifactName(String artifactName) {
        this.artifactName = artifactName;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public CreateArtifactRequest withArtifactName(String artifactName) {
        this.setArtifactName(artifactName);
        return this;
    }

    public void setSource(ArtifactSource source) {
        this.source = source;
    }

    public ArtifactSource getSource() {
        return this.source;
    }

    public CreateArtifactRequest withSource(ArtifactSource source) {
        this.setSource(source);
        return this;
    }

    public void setArtifactType(String artifactType) {
        this.artifactType = artifactType;
    }

    public String getArtifactType() {
        return this.artifactType;
    }

    public CreateArtifactRequest withArtifactType(String artifactType) {
        this.setArtifactType(artifactType);
        return this;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public CreateArtifactRequest withProperties(Map<String, String> properties) {
        this.setProperties(properties);
        return this;
    }

    public CreateArtifactRequest addPropertiesEntry(String key, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.properties.put(key, value);
        return this;
    }

    public CreateArtifactRequest clearPropertiesEntries() {
        this.properties = null;
        return this;
    }

    public void setMetadataProperties(MetadataProperties metadataProperties) {
        this.metadataProperties = metadataProperties;
    }

    public MetadataProperties getMetadataProperties() {
        return this.metadataProperties;
    }

    public CreateArtifactRequest withMetadataProperties(MetadataProperties metadataProperties) {
        this.setMetadataProperties(metadataProperties);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateArtifactRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateArtifactRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getArtifactName() != null) {
            sb.append("ArtifactName: ").append(this.getArtifactName()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getArtifactType() != null) {
            sb.append("ArtifactType: ").append(this.getArtifactType()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties()).append(",");
        }
        if (this.getMetadataProperties() != null) {
            sb.append("MetadataProperties: ").append(this.getMetadataProperties()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateArtifactRequest)) {
            return false;
        }
        CreateArtifactRequest other = (CreateArtifactRequest)obj;
        if (other.getArtifactName() == null ^ this.getArtifactName() == null) {
            return false;
        }
        if (other.getArtifactName() != null && !other.getArtifactName().equals(this.getArtifactName())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getArtifactType() == null ^ this.getArtifactType() == null) {
            return false;
        }
        if (other.getArtifactType() != null && !other.getArtifactType().equals(this.getArtifactType())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !other.getProperties().equals(this.getProperties())) {
            return false;
        }
        if (other.getMetadataProperties() == null ^ this.getMetadataProperties() == null) {
            return false;
        }
        if (other.getMetadataProperties() != null && !other.getMetadataProperties().equals(this.getMetadataProperties())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getArtifactName() == null ? 0 : this.getArtifactName().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getArtifactType() == null ? 0 : this.getArtifactType().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        hashCode = 31 * hashCode + (this.getMetadataProperties() == null ? 0 : this.getMetadataProperties().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateArtifactRequest clone() {
        return (CreateArtifactRequest)super.clone();
    }
}

