/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.CandidateArtifactLocations;
import com.amazonaws.services.sagemaker.model.MetricDatum;
import com.amazonaws.services.sagemaker.model.transform.CandidatePropertiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CandidateProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private CandidateArtifactLocations candidateArtifactLocations;
    private List<MetricDatum> candidateMetrics;

    public void setCandidateArtifactLocations(CandidateArtifactLocations candidateArtifactLocations) {
        this.candidateArtifactLocations = candidateArtifactLocations;
    }

    public CandidateArtifactLocations getCandidateArtifactLocations() {
        return this.candidateArtifactLocations;
    }

    public CandidateProperties withCandidateArtifactLocations(CandidateArtifactLocations candidateArtifactLocations) {
        this.setCandidateArtifactLocations(candidateArtifactLocations);
        return this;
    }

    public List<MetricDatum> getCandidateMetrics() {
        return this.candidateMetrics;
    }

    public void setCandidateMetrics(Collection<MetricDatum> candidateMetrics) {
        if (candidateMetrics == null) {
            this.candidateMetrics = null;
            return;
        }
        this.candidateMetrics = new ArrayList<MetricDatum>(candidateMetrics);
    }

    public CandidateProperties withCandidateMetrics(MetricDatum ... candidateMetrics) {
        if (this.candidateMetrics == null) {
            this.setCandidateMetrics(new ArrayList<MetricDatum>(candidateMetrics.length));
        }
        for (MetricDatum ele : candidateMetrics) {
            this.candidateMetrics.add(ele);
        }
        return this;
    }

    public CandidateProperties withCandidateMetrics(Collection<MetricDatum> candidateMetrics) {
        this.setCandidateMetrics(candidateMetrics);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCandidateArtifactLocations() != null) {
            sb.append("CandidateArtifactLocations: ").append(this.getCandidateArtifactLocations()).append(",");
        }
        if (this.getCandidateMetrics() != null) {
            sb.append("CandidateMetrics: ").append(this.getCandidateMetrics());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CandidateProperties)) {
            return false;
        }
        CandidateProperties other = (CandidateProperties)obj;
        if (other.getCandidateArtifactLocations() == null ^ this.getCandidateArtifactLocations() == null) {
            return false;
        }
        if (other.getCandidateArtifactLocations() != null && !other.getCandidateArtifactLocations().equals(this.getCandidateArtifactLocations())) {
            return false;
        }
        if (other.getCandidateMetrics() == null ^ this.getCandidateMetrics() == null) {
            return false;
        }
        return other.getCandidateMetrics() == null || other.getCandidateMetrics().equals(this.getCandidateMetrics());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCandidateArtifactLocations() == null ? 0 : this.getCandidateArtifactLocations().hashCode());
        hashCode = 31 * hashCode + (this.getCandidateMetrics() == null ? 0 : this.getCandidateMetrics().hashCode());
        return hashCode;
    }

    public CandidateProperties clone() {
        try {
            return (CandidateProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CandidatePropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

