/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.OutputParameter;
import com.amazonaws.services.sagemaker.model.transform.CallbackStepMetadataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CallbackStepMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private String callbackToken;
    private String sqsQueueUrl;
    private List<OutputParameter> outputParameters;

    public void setCallbackToken(String callbackToken) {
        this.callbackToken = callbackToken;
    }

    public String getCallbackToken() {
        return this.callbackToken;
    }

    public CallbackStepMetadata withCallbackToken(String callbackToken) {
        this.setCallbackToken(callbackToken);
        return this;
    }

    public void setSqsQueueUrl(String sqsQueueUrl) {
        this.sqsQueueUrl = sqsQueueUrl;
    }

    public String getSqsQueueUrl() {
        return this.sqsQueueUrl;
    }

    public CallbackStepMetadata withSqsQueueUrl(String sqsQueueUrl) {
        this.setSqsQueueUrl(sqsQueueUrl);
        return this;
    }

    public List<OutputParameter> getOutputParameters() {
        return this.outputParameters;
    }

    public void setOutputParameters(Collection<OutputParameter> outputParameters) {
        if (outputParameters == null) {
            this.outputParameters = null;
            return;
        }
        this.outputParameters = new ArrayList<OutputParameter>(outputParameters);
    }

    public CallbackStepMetadata withOutputParameters(OutputParameter ... outputParameters) {
        if (this.outputParameters == null) {
            this.setOutputParameters(new ArrayList<OutputParameter>(outputParameters.length));
        }
        for (OutputParameter ele : outputParameters) {
            this.outputParameters.add(ele);
        }
        return this;
    }

    public CallbackStepMetadata withOutputParameters(Collection<OutputParameter> outputParameters) {
        this.setOutputParameters(outputParameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCallbackToken() != null) {
            sb.append("CallbackToken: ").append(this.getCallbackToken()).append(",");
        }
        if (this.getSqsQueueUrl() != null) {
            sb.append("SqsQueueUrl: ").append(this.getSqsQueueUrl()).append(",");
        }
        if (this.getOutputParameters() != null) {
            sb.append("OutputParameters: ").append(this.getOutputParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallbackStepMetadata)) {
            return false;
        }
        CallbackStepMetadata other = (CallbackStepMetadata)obj;
        if (other.getCallbackToken() == null ^ this.getCallbackToken() == null) {
            return false;
        }
        if (other.getCallbackToken() != null && !other.getCallbackToken().equals(this.getCallbackToken())) {
            return false;
        }
        if (other.getSqsQueueUrl() == null ^ this.getSqsQueueUrl() == null) {
            return false;
        }
        if (other.getSqsQueueUrl() != null && !other.getSqsQueueUrl().equals(this.getSqsQueueUrl())) {
            return false;
        }
        if (other.getOutputParameters() == null ^ this.getOutputParameters() == null) {
            return false;
        }
        return other.getOutputParameters() == null || other.getOutputParameters().equals(this.getOutputParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCallbackToken() == null ? 0 : this.getCallbackToken().hashCode());
        hashCode = 31 * hashCode + (this.getSqsQueueUrl() == null ? 0 : this.getSqsQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getOutputParameters() == null ? 0 : this.getOutputParameters().hashCode());
        return hashCode;
    }

    public CallbackStepMetadata clone() {
        try {
            return (CallbackStepMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CallbackStepMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

