/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.Alarm;
import com.amazonaws.services.sagemaker.model.transform.AutoRollbackConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutoRollbackConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Alarm> alarms;

    public List<Alarm> getAlarms() {
        return this.alarms;
    }

    public void setAlarms(Collection<Alarm> alarms) {
        if (alarms == null) {
            this.alarms = null;
            return;
        }
        this.alarms = new ArrayList<Alarm>(alarms);
    }

    public AutoRollbackConfig withAlarms(Alarm ... alarms) {
        if (this.alarms == null) {
            this.setAlarms(new ArrayList<Alarm>(alarms.length));
        }
        for (Alarm ele : alarms) {
            this.alarms.add(ele);
        }
        return this;
    }

    public AutoRollbackConfig withAlarms(Collection<Alarm> alarms) {
        this.setAlarms(alarms);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlarms() != null) {
            sb.append("Alarms: ").append(this.getAlarms());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoRollbackConfig)) {
            return false;
        }
        AutoRollbackConfig other = (AutoRollbackConfig)obj;
        if (other.getAlarms() == null ^ this.getAlarms() == null) {
            return false;
        }
        return other.getAlarms() == null || other.getAlarms().equals(this.getAlarms());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlarms() == null ? 0 : this.getAlarms().hashCode());
        return hashCode;
    }

    public AutoRollbackConfig clone() {
        try {
            return (AutoRollbackConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoRollbackConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

