/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.AutoMLS3DataType;
import com.amazonaws.services.sagemaker.model.transform.AutoMLS3DataSourceMarshaller;
import java.io.Serializable;

public class AutoMLS3DataSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String s3DataType;
    private String s3Uri;

    public void setS3DataType(String s3DataType) {
        this.s3DataType = s3DataType;
    }

    public String getS3DataType() {
        return this.s3DataType;
    }

    public AutoMLS3DataSource withS3DataType(String s3DataType) {
        this.setS3DataType(s3DataType);
        return this;
    }

    public AutoMLS3DataSource withS3DataType(AutoMLS3DataType s3DataType) {
        this.s3DataType = s3DataType.toString();
        return this;
    }

    public void setS3Uri(String s3Uri) {
        this.s3Uri = s3Uri;
    }

    public String getS3Uri() {
        return this.s3Uri;
    }

    public AutoMLS3DataSource withS3Uri(String s3Uri) {
        this.setS3Uri(s3Uri);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getS3DataType() != null) {
            sb.append("S3DataType: ").append(this.getS3DataType()).append(",");
        }
        if (this.getS3Uri() != null) {
            sb.append("S3Uri: ").append(this.getS3Uri());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLS3DataSource)) {
            return false;
        }
        AutoMLS3DataSource other = (AutoMLS3DataSource)obj;
        if (other.getS3DataType() == null ^ this.getS3DataType() == null) {
            return false;
        }
        if (other.getS3DataType() != null && !other.getS3DataType().equals(this.getS3DataType())) {
            return false;
        }
        if (other.getS3Uri() == null ^ this.getS3Uri() == null) {
            return false;
        }
        return other.getS3Uri() == null || other.getS3Uri().equals(this.getS3Uri());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getS3DataType() == null ? 0 : this.getS3DataType().hashCode());
        hashCode = 31 * hashCode + (this.getS3Uri() == null ? 0 : this.getS3Uri().hashCode());
        return hashCode;
    }

    public AutoMLS3DataSource clone() {
        try {
            return (AutoMLS3DataSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoMLS3DataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

