/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.transform.AutoMLContainerDefinitionMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AutoMLContainerDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String image;
    private String modelDataUrl;
    private Map<String, String> environment;

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public AutoMLContainerDefinition withImage(String image) {
        this.setImage(image);
        return this;
    }

    public void setModelDataUrl(String modelDataUrl) {
        this.modelDataUrl = modelDataUrl;
    }

    public String getModelDataUrl() {
        return this.modelDataUrl;
    }

    public AutoMLContainerDefinition withModelDataUrl(String modelDataUrl) {
        this.setModelDataUrl(modelDataUrl);
        return this;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public AutoMLContainerDefinition withEnvironment(Map<String, String> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public AutoMLContainerDefinition addEnvironmentEntry(String key, String value) {
        if (null == this.environment) {
            this.environment = new HashMap<String, String>();
        }
        if (this.environment.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.environment.put(key, value);
        return this;
    }

    public AutoMLContainerDefinition clearEnvironmentEntries() {
        this.environment = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getModelDataUrl() != null) {
            sb.append("ModelDataUrl: ").append(this.getModelDataUrl()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLContainerDefinition)) {
            return false;
        }
        AutoMLContainerDefinition other = (AutoMLContainerDefinition)obj;
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getModelDataUrl() == null ^ this.getModelDataUrl() == null) {
            return false;
        }
        if (other.getModelDataUrl() != null && !other.getModelDataUrl().equals(this.getModelDataUrl())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        return other.getEnvironment() == null || other.getEnvironment().equals(this.getEnvironment());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getModelDataUrl() == null ? 0 : this.getModelDataUrl().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        return hashCode;
    }

    public AutoMLContainerDefinition clone() {
        try {
            return (AutoMLContainerDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AutoMLContainerDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

