/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.transform.AppSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AppSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String imageUri;
    private List<String> containerEntrypoint;
    private List<String> containerArguments;

    public void setImageUri(String imageUri) {
        this.imageUri = imageUri;
    }

    public String getImageUri() {
        return this.imageUri;
    }

    public AppSpecification withImageUri(String imageUri) {
        this.setImageUri(imageUri);
        return this;
    }

    public List<String> getContainerEntrypoint() {
        return this.containerEntrypoint;
    }

    public void setContainerEntrypoint(Collection<String> containerEntrypoint) {
        if (containerEntrypoint == null) {
            this.containerEntrypoint = null;
            return;
        }
        this.containerEntrypoint = new ArrayList<String>(containerEntrypoint);
    }

    public AppSpecification withContainerEntrypoint(String ... containerEntrypoint) {
        if (this.containerEntrypoint == null) {
            this.setContainerEntrypoint(new ArrayList<String>(containerEntrypoint.length));
        }
        for (String ele : containerEntrypoint) {
            this.containerEntrypoint.add(ele);
        }
        return this;
    }

    public AppSpecification withContainerEntrypoint(Collection<String> containerEntrypoint) {
        this.setContainerEntrypoint(containerEntrypoint);
        return this;
    }

    public List<String> getContainerArguments() {
        return this.containerArguments;
    }

    public void setContainerArguments(Collection<String> containerArguments) {
        if (containerArguments == null) {
            this.containerArguments = null;
            return;
        }
        this.containerArguments = new ArrayList<String>(containerArguments);
    }

    public AppSpecification withContainerArguments(String ... containerArguments) {
        if (this.containerArguments == null) {
            this.setContainerArguments(new ArrayList<String>(containerArguments.length));
        }
        for (String ele : containerArguments) {
            this.containerArguments.add(ele);
        }
        return this;
    }

    public AppSpecification withContainerArguments(Collection<String> containerArguments) {
        this.setContainerArguments(containerArguments);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageUri() != null) {
            sb.append("ImageUri: ").append(this.getImageUri()).append(",");
        }
        if (this.getContainerEntrypoint() != null) {
            sb.append("ContainerEntrypoint: ").append(this.getContainerEntrypoint()).append(",");
        }
        if (this.getContainerArguments() != null) {
            sb.append("ContainerArguments: ").append(this.getContainerArguments());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppSpecification)) {
            return false;
        }
        AppSpecification other = (AppSpecification)obj;
        if (other.getImageUri() == null ^ this.getImageUri() == null) {
            return false;
        }
        if (other.getImageUri() != null && !other.getImageUri().equals(this.getImageUri())) {
            return false;
        }
        if (other.getContainerEntrypoint() == null ^ this.getContainerEntrypoint() == null) {
            return false;
        }
        if (other.getContainerEntrypoint() != null && !other.getContainerEntrypoint().equals(this.getContainerEntrypoint())) {
            return false;
        }
        if (other.getContainerArguments() == null ^ this.getContainerArguments() == null) {
            return false;
        }
        return other.getContainerArguments() == null || other.getContainerArguments().equals(this.getContainerArguments());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageUri() == null ? 0 : this.getImageUri().hashCode());
        hashCode = 31 * hashCode + (this.getContainerEntrypoint() == null ? 0 : this.getContainerEntrypoint().hashCode());
        hashCode = 31 * hashCode + (this.getContainerArguments() == null ? 0 : this.getContainerArguments().hashCode());
        return hashCode;
    }

    public AppSpecification clone() {
        try {
            return (AppSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AppSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

