/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.awslambda.model;

import com.amazonaws.services.lambda.model.InvokeResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class AwsLambdaResult {
    private Integer statusCode;
    private String executedVersion;
    private Object payload;

    public AwsLambdaResult(InvokeResult invokeResult, ObjectMapper objectMapper) {
        this.statusCode = invokeResult.getStatusCode();
        this.executedVersion = invokeResult.getExecutedVersion();
        try {
            this.payload = objectMapper.readValue(invokeResult.getPayload().array(), Object.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getExecutedVersion() {
        return this.executedVersion;
    }

    public void setExecutedVersion(String executedVersion) {
        this.executedVersion = executedVersion;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public String toString() {
        return "AwsLambdaResult{statusCode=" + this.statusCode + ", executedVersion='" + this.executedVersion + "', payload='" + String.valueOf(this.payload) + "'}";
    }
}

