/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.awslambda;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import connector.com.fasterxml.jackson.core.JsonProcessingException;
import connector.com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.api.annotation.OutboundConnector;
import io.camunda.connector.api.outbound.OutboundConnectorContext;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.aws.AwsUtils;
import io.camunda.connector.aws.CredentialsProviderSupport;
import io.camunda.connector.aws.ObjectMapperSupplier;
import io.camunda.connector.awslambda.AwsLambdaSupplier;
import io.camunda.connector.awslambda.model.AwsLambdaRequest;
import io.camunda.connector.awslambda.model.AwsLambdaResult;

@OutboundConnector(name="AWSLambda", inputVariables={"authentication", "configuration", "awsFunction"}, type="io.camunda:aws-lambda:1")
public class LambdaConnectorFunction
implements OutboundConnectorFunction {
    private final AwsLambdaSupplier awsLambdaSupplier;
    private final ObjectMapper objectMapper;

    public LambdaConnectorFunction() {
        this(new AwsLambdaSupplier(), ObjectMapperSupplier.getMapperInstance());
    }

    public LambdaConnectorFunction(AwsLambdaSupplier awsLambdaSupplier, ObjectMapper objectMapper) {
        this.awsLambdaSupplier = awsLambdaSupplier;
        this.objectMapper = objectMapper;
    }

    public Object execute(OutboundConnectorContext context) {
        AwsLambdaRequest request = (AwsLambdaRequest)context.bindVariables(AwsLambdaRequest.class);
        return new AwsLambdaResult(this.invokeLambdaFunction(request), this.objectMapper);
    }

    private InvokeResult invokeLambdaFunction(AwsLambdaRequest request) {
        String region = AwsUtils.extractRegionOrDefault(request.getConfiguration(), request.getAwsFunction().getRegion());
        AWSLambda awsLambda = this.awsLambdaSupplier.awsLambdaService(CredentialsProviderSupport.credentialsProvider(request), region);
        try {
            InvokeRequest invokeRequest = new InvokeRequest().withFunctionName(request.getAwsFunction().getFunctionName()).withPayload(this.objectMapper.writeValueAsString(request.getAwsFunction().getPayload()));
            InvokeResult invokeResult = awsLambda.invoke(invokeRequest);
            return invokeResult;
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error mapping payload to json.");
        }
        finally {
            if (awsLambda != null) {
                awsLambda.shutdown();
            }
        }
    }
}

