/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathSubExpression;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.lambda.model.GetFunctionResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import connector.com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class FunctionUpdatedV2 {
    FunctionUpdatedV2() {
    }

    static class IsInProgressMatcher
    extends WaiterAcceptor<GetFunctionResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsInProgressMatcher() {
        }

        @Override
        public boolean matches(GetFunctionResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"InProgress\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathSubExpression(new JmesPathField("Configuration"), new JmesPathField("LastUpdateStatus"));
        }
    }

    static class IsFailedMatcher
    extends WaiterAcceptor<GetFunctionResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsFailedMatcher() {
        }

        @Override
        public boolean matches(GetFunctionResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Failed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathSubExpression(new JmesPathField("Configuration"), new JmesPathField("LastUpdateStatus"));
        }
    }

    static class IsSuccessfulMatcher
    extends WaiterAcceptor<GetFunctionResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsSuccessfulMatcher() {
        }

        @Override
        public boolean matches(GetFunctionResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.path(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"Successful\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathSubExpression(new JmesPathField("Configuration"), new JmesPathField("LastUpdateStatus"));
        }
    }
}

