/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationRequest;
import com.amazonaws.services.lambda.model.GetFunctionConfigurationResult;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.services.lambda.model.GetFunctionResult;
import com.amazonaws.services.lambda.waiters.FunctionActive;
import com.amazonaws.services.lambda.waiters.FunctionActiveV2;
import com.amazonaws.services.lambda.waiters.FunctionExists;
import com.amazonaws.services.lambda.waiters.FunctionUpdated;
import com.amazonaws.services.lambda.waiters.FunctionUpdatedV2;
import com.amazonaws.services.lambda.waiters.GetFunctionConfigurationFunction;
import com.amazonaws.services.lambda.waiters.GetFunctionFunction;
import com.amazonaws.services.lambda.waiters.PublishedVersionActive;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;

public class AWSLambdaWaiters {
    private final AWSLambda client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AWSLambdaWaiters");

    @SdkInternalApi
    public AWSLambdaWaiters(AWSLambda client) {
        this.client = client;
    }

    public Waiter<GetFunctionRequest> functionExists() {
        return new WaiterBuilder<GetFunctionRequest, GetFunctionResult>().withSdkFunction(new GetFunctionFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new FunctionExists.IsResourceNotFoundExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetFunctionConfigurationRequest> functionActive() {
        return new WaiterBuilder<GetFunctionConfigurationRequest, GetFunctionConfigurationResult>().withSdkFunction(new GetFunctionConfigurationFunction(this.client)).withAcceptors(new FunctionActive.IsActiveMatcher(), new FunctionActive.IsFailedMatcher(), new FunctionActive.IsPendingMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetFunctionConfigurationRequest> publishedVersionActive() {
        return new WaiterBuilder<GetFunctionConfigurationRequest, GetFunctionConfigurationResult>().withSdkFunction(new GetFunctionConfigurationFunction(this.client)).withAcceptors(new PublishedVersionActive.IsActiveMatcher(), new PublishedVersionActive.IsFailedMatcher(), new PublishedVersionActive.IsPendingMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(312), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetFunctionConfigurationRequest> functionUpdated() {
        return new WaiterBuilder<GetFunctionConfigurationRequest, GetFunctionConfigurationResult>().withSdkFunction(new GetFunctionConfigurationFunction(this.client)).withAcceptors(new FunctionUpdated.IsSuccessfulMatcher(), new FunctionUpdated.IsFailedMatcher(), new FunctionUpdated.IsInProgressMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetFunctionRequest> functionActiveV2() {
        return new WaiterBuilder<GetFunctionRequest, GetFunctionResult>().withSdkFunction(new GetFunctionFunction(this.client)).withAcceptors(new FunctionActiveV2.IsActiveMatcher(), new FunctionActiveV2.IsFailedMatcher(), new FunctionActiveV2.IsPendingMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(300), new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetFunctionRequest> functionUpdatedV2() {
        return new WaiterBuilder<GetFunctionRequest, GetFunctionResult>().withSdkFunction(new GetFunctionFunction(this.client)).withAcceptors(new FunctionUpdatedV2.IsSuccessfulMatcher(), new FunctionUpdatedV2.IsFailedMatcher(), new FunctionUpdatedV2.IsInProgressMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(300), new FixedDelayStrategy(1))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

