/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.services.lambda.model.ScalingConfig;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import connector.com.fasterxml.jackson.core.JsonToken;

public class ScalingConfigJsonUnmarshaller
implements Unmarshaller<ScalingConfig, JsonUnmarshallerContext> {
    private static ScalingConfigJsonUnmarshaller instance;

    @Override
    public ScalingConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        ScalingConfig scalingConfig = new ScalingConfig();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("MaximumConcurrency", targetDepth)) {
                    context.nextToken();
                    scalingConfig.setMaximumConcurrency(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return scalingConfig;
    }

    public static ScalingConfigJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ScalingConfigJsonUnmarshaller();
        }
        return instance;
    }
}

