/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lambda.model.LayersListItem;

@SdkInternalApi
public class LayersListItemMarshaller {
    private static final MarshallingInfo<String> LAYERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerName").build();
    private static final MarshallingInfo<String> LAYERARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LayerArn").build();
    private static final MarshallingInfo<StructuredPojo> LATESTMATCHINGVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestMatchingVersion").build();
    private static final LayersListItemMarshaller instance = new LayersListItemMarshaller();

    public static LayersListItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(LayersListItem layersListItem, ProtocolMarshaller protocolMarshaller) {
        if (layersListItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(layersListItem.getLayerName(), LAYERNAME_BINDING);
            protocolMarshaller.marshall(layersListItem.getLayerArn(), LAYERARN_BINDING);
            protocolMarshaller.marshall(layersListItem.getLatestMatchingVersion(), LATESTMATCHINGVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

