/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lambda.model.transform.SelfManagedEventSourceMarshaller;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class SelfManagedEventSource
implements Serializable,
Cloneable,
StructuredPojo {
    private SdkInternalMap<String, List<String>> endpoints;

    public Map<String, List<String>> getEndpoints() {
        if (this.endpoints == null) {
            this.endpoints = new SdkInternalMap();
        }
        return this.endpoints;
    }

    public void setEndpoints(Map<String, List<String>> endpoints) {
        this.endpoints = endpoints == null ? null : new SdkInternalMap<String, List<String>>(endpoints);
    }

    public SelfManagedEventSource withEndpoints(Map<String, List<String>> endpoints) {
        this.setEndpoints(endpoints);
        return this;
    }

    public SelfManagedEventSource addEndpointsEntry(String key, List<String> value) {
        if (null == this.endpoints) {
            this.endpoints = new SdkInternalMap();
        }
        if (this.endpoints.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.endpoints.put(key, value);
        return this;
    }

    public SelfManagedEventSource clearEndpointsEntries() {
        this.endpoints = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpoints() != null) {
            sb.append("Endpoints: ").append(this.getEndpoints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfManagedEventSource)) {
            return false;
        }
        SelfManagedEventSource other = (SelfManagedEventSource)obj;
        if (other.getEndpoints() == null ^ this.getEndpoints() == null) {
            return false;
        }
        return other.getEndpoints() == null || other.getEndpoints().equals(this.getEndpoints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpoints() == null ? 0 : this.getEndpoints().hashCode());
        return hashCode;
    }

    public SelfManagedEventSource clone() {
        try {
            return (SelfManagedEventSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SelfManagedEventSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

