/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.awslambda;

import com.amazonaws.services.lambda.AWSLambda;
import com.amazonaws.services.lambda.model.InvokeRequest;
import com.amazonaws.services.lambda.model.InvokeResult;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.camunda.connector.api.annotation.OutboundConnector;
import io.camunda.connector.api.outbound.OutboundConnectorContext;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.awslambda.AwsLambdaSupplier;
import io.camunda.connector.awslambda.model.AwsLambdaRequest;
import io.camunda.connector.awslambda.model.AwsLambdaResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OutboundConnector(name="AWSLambda", inputVariables={"authentication", "awsFunction"}, type="io.camunda:aws-lambda:1")
public class LambdaConnectorFunction
implements OutboundConnectorFunction {
    private static final Logger LOGGER = LoggerFactory.getLogger(LambdaConnectorFunction.class);
    private final AwsLambdaSupplier awsLambdaSupplier;
    private final Gson gson;

    public LambdaConnectorFunction() {
        this.awsLambdaSupplier = new AwsLambdaSupplier();
        this.gson = new GsonBuilder().create();
    }

    public LambdaConnectorFunction(AwsLambdaSupplier awsLambdaSupplier, Gson gson) {
        this.awsLambdaSupplier = awsLambdaSupplier;
        this.gson = gson;
    }

    public Object execute(OutboundConnectorContext context) {
        AwsLambdaRequest request = (AwsLambdaRequest)context.getVariablesAsType(AwsLambdaRequest.class);
        LOGGER.info("Executing my connector with request {}", (Object)request);
        context.validate((Object)request);
        context.replaceSecrets((Object)request);
        return new AwsLambdaResult(this.invokeLambdaFunction(request), this.gson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InvokeResult invokeLambdaFunction(AwsLambdaRequest request) {
        AWSLambda awsLambda = this.awsLambdaSupplier.awsLambdaService(request.getAuthentication(), request.getAwsFunction().getRegion());
        InvokeRequest invokeRequest = new InvokeRequest().withFunctionName(request.getAwsFunction().getFunctionName()).withPayload(this.gson.toJson(request.getAwsFunction().getPayload()));
        try {
            InvokeResult invokeResult = awsLambda.invoke(invokeRequest);
            return invokeResult;
        }
        finally {
            if (awsLambda != null) {
                awsLambda.shutdown();
            }
        }
    }
}

