/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.aws.dynamodb.operation.table;

import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.BillingMode;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import io.camunda.connector.aws.dynamodb.model.CreateTable;
import io.camunda.connector.aws.dynamodb.operation.AwsDynamoDbOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateTableOperation
implements AwsDynamoDbOperation {
    private final CreateTable createTableModel;

    public CreateTableOperation(CreateTable createTableModel) {
        this.createTableModel = createTableModel;
    }

    public TableDescription invoke(DynamoDB dynamoDB) {
        try {
            return dynamoDB.createTable(this.buildCreateTableRequest()).waitForActive();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private CreateTableRequest buildCreateTableRequest() {
        List<KeySchemaElement> keySchemaElements = this.buildKeySchemaElements();
        List<AttributeDefinition> attributeDefinitions = this.buildAttributeDefinitions();
        CreateTableRequest request = new CreateTableRequest().withTableName(this.createTableModel.tableName()).withKeySchema(keySchemaElements).withAttributeDefinitions(attributeDefinitions).withDeletionProtectionEnabled(Boolean.valueOf(this.createTableModel.deletionProtection()));
        BillingMode billingMode = Optional.ofNullable(this.createTableModel.billingModeStr()).map(BillingMode::valueOf).orElse(BillingMode.PROVISIONED);
        request.withBillingMode(billingMode);
        if (BillingMode.PROVISIONED == billingMode) {
            request.withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(this.createTableModel.readCapacityUnits()).withWriteCapacityUnits(this.createTableModel.writeCapacityUnits()));
        }
        return request;
    }

    private List<KeySchemaElement> buildKeySchemaElements() {
        ArrayList<KeySchemaElement> keySchemaElements = new ArrayList<KeySchemaElement>();
        keySchemaElements.add(new KeySchemaElement(this.createTableModel.partitionKey(), this.createTableModel.partitionKeyRole()));
        if (Objects.nonNull(this.createTableModel.sortKey()) && !this.createTableModel.sortKey().isBlank()) {
            keySchemaElements.add(new KeySchemaElement(this.createTableModel.sortKey(), this.createTableModel.sortKeyRole()));
        }
        return keySchemaElements;
    }

    private List<AttributeDefinition> buildAttributeDefinitions() {
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition(this.createTableModel.partitionKey(), this.createTableModel.partitionKeyType()));
        if (Objects.nonNull(this.createTableModel.sortKey()) && !this.createTableModel.sortKey().isBlank()) {
            attributeDefinitions.add(new AttributeDefinition(this.createTableModel.sortKey(), this.createTableModel.sortKeyType()));
        }
        return attributeDefinitions;
    }
}

