/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.aws.dynamodb.operation.item;

import com.amazonaws.services.dynamodbv2.document.AttributeUpdate;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import io.camunda.connector.aws.dynamodb.model.UpdateItem;
import io.camunda.connector.aws.dynamodb.operation.AwsDynamoDbOperation;
import java.util.List;
import java.util.Map;

public class UpdateItemOperation
implements AwsDynamoDbOperation {
    private final UpdateItem updateItemModel;

    public UpdateItemOperation(UpdateItem updateItemModel) {
        this.updateItemModel = updateItemModel;
    }

    @Override
    public Object invoke(DynamoDB dynamoDB) {
        List<AttributeUpdate> attributeUpdates = this.updateItemModel.keyAttributes().entrySet().stream().map(entry -> this.createAttributeUpdate((String)entry.getKey(), entry.getValue(), this.updateItemModel.attributeAction())).toList();
        return dynamoDB.getTable(this.updateItemModel.tableName()).updateItem(this.buildPrimaryKey(this.updateItemModel.primaryKeyComponents()), (AttributeUpdate[])attributeUpdates.toArray(AttributeUpdate[]::new));
    }

    private AttributeUpdate createAttributeUpdate(String key, Object value, String action) {
        AttributeUpdate update = new AttributeUpdate(key);
        return switch (action.toLowerCase()) {
            case "put" -> update.put(value);
            case "delete" -> update.delete();
            default -> throw new IllegalArgumentException("Unsupported attribute action: " + action);
        };
    }

    private PrimaryKey buildPrimaryKey(Map<String, Object> primaryKeyMap) {
        PrimaryKey primaryKey = new PrimaryKey();
        primaryKeyMap.forEach((arg_0, arg_1) -> ((PrimaryKey)primaryKey).addComponent(arg_0, arg_1));
        return primaryKey;
    }
}

