/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.aws.dynamodb;

import io.camunda.connector.api.annotation.OutboundConnector;
import io.camunda.connector.api.outbound.OutboundConnectorContext;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.aws.CredentialsProviderSupport;
import io.camunda.connector.aws.dynamodb.AwsDynamoDbClientSupplier;
import io.camunda.connector.aws.dynamodb.AwsDynamoDbOperationFactory;
import io.camunda.connector.aws.dynamodb.AwsDynamoDbRequest;
import io.camunda.connector.aws.model.impl.AwsBaseRequest;
import io.camunda.connector.generator.java.annotation.ElementTemplate;

@OutboundConnector(name="AWS DynamoDB", inputVariables={"authentication", "configuration", "input"}, type="io.camunda:aws-dynamodb:1")
@ElementTemplate(id="io.camunda.connectors.AWSDynamoDB.v1", name="AWS DynamoDB Outbound Connector", version=7, description="Manage tables and items with AWS DynamoDB.", metadata=@ElementTemplate.Metadata(keywords={"create table", "delete table", "update table", "describe table", "scan table", "add item", "delete item", "get item", "update item"}), documentationRef="https://docs.camunda.io/docs/components/connectors/out-of-the-box-connectors/aws-dynamodb/", propertyGroups={@ElementTemplate.PropertyGroup(id="operation", label="Operation"), @ElementTemplate.PropertyGroup(id="authentication", label="Authentication"), @ElementTemplate.PropertyGroup(id="configuration", label="Queue properties"), @ElementTemplate.PropertyGroup(id="input", label="Input")}, inputDataClass=AwsDynamoDbRequest.class, icon="icon.svg")
public class AwsDynamoDbServiceConnectorFunction
implements OutboundConnectorFunction {
    public Object execute(OutboundConnectorContext context) throws Exception {
        AwsDynamoDbOperationFactory operationFactory = AwsDynamoDbOperationFactory.getInstance();
        AwsDynamoDbRequest dynamoDbRequest = (AwsDynamoDbRequest)((Object)context.bindVariables(AwsDynamoDbRequest.class));
        return operationFactory.createOperation(dynamoDbRequest.getInput()).invoke(AwsDynamoDbClientSupplier.getDynamoDdClient(CredentialsProviderSupport.credentialsProvider((AwsBaseRequest)dynamoDbRequest), dynamoDbRequest.getConfiguration().region()));
    }
}

